/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.beans.factory.support.NullBean;
import org.springframework.core.AttributeAccessor;
import org.springframework.core.ResolvableType;

public abstract class FactoryBeanRegistrySupport
extends DefaultSingletonBeanRegistry {
    private final Map<String, Object> factoryBeanObjectCache = new ConcurrentHashMap<String, Object>(16);

    protected @Nullable Class<?> getTypeForFactoryBean(FactoryBean<?> factoryBean) {
        try {
            return factoryBean.getObjectType();
        }
        catch (Throwable ex) {
            this.logger.info((Object)"FactoryBean threw exception from getObjectType, despite the contract saying that it should return null if the type of its object cannot be determined yet", ex);
            return null;
        }
    }

    ResolvableType getTypeForFactoryBeanFromAttributes(AttributeAccessor attributes) {
        Object attribute = attributes.getAttribute("factoryBeanObjectType");
        if (attribute == null) {
            return ResolvableType.NONE;
        }
        if (attribute instanceof ResolvableType) {
            ResolvableType resolvableType2 = (ResolvableType)attribute;
            return resolvableType2;
        }
        if (attribute instanceof Class) {
            Class clazz = (Class)attribute;
            return ResolvableType.forClass((Class)clazz);
        }
        throw new IllegalArgumentException("Invalid value type for attribute 'factoryBeanObjectType': " + attribute.getClass().getName());
    }

    ResolvableType getFactoryBeanGeneric(@Nullable ResolvableType type) {
        return type != null ? type.as(FactoryBean.class).getGeneric(new int[0]) : ResolvableType.NONE;
    }

    protected @Nullable Object getCachedObjectForFactoryBean(String beanName) {
        return this.factoryBeanObjectCache.get(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectFromFactoryBean(FactoryBean<?> factory, String beanName, boolean shouldPostProcess) {
        if (factory.isSingleton() && this.containsSingleton(beanName)) {
            boolean locked;
            Boolean lockFlag = this.isCurrentThreadAllowedToHoldSingletonLock();
            if (lockFlag == null) {
                this.singletonLock.lock();
                locked = true;
            } else {
                locked = lockFlag != false && this.singletonLock.tryLock();
            }
            try {
                Object object = this.factoryBeanObjectCache.get(beanName);
                if (object == null) {
                    object = this.doGetObjectFromFactoryBean(factory, beanName);
                    Object alreadyThere = this.factoryBeanObjectCache.get(beanName);
                    if (alreadyThere != null) {
                        object = alreadyThere;
                    } else {
                        if (shouldPostProcess) {
                            if (locked) {
                                if (this.isSingletonCurrentlyInCreation(beanName)) {
                                    Object object2 = object;
                                    return object2;
                                }
                                this.beforeSingletonCreation(beanName);
                            }
                            try {
                                object = this.postProcessObjectFromFactoryBean(object, beanName);
                            }
                            catch (Throwable ex) {
                                throw new BeanCreationException(beanName, "Post-processing of FactoryBean's singleton object failed", ex);
                            }
                            finally {
                                if (locked) {
                                    this.afterSingletonCreation(beanName);
                                }
                            }
                        }
                        if (this.containsSingleton(beanName)) {
                            this.factoryBeanObjectCache.put(beanName, object);
                        }
                    }
                }
                Object object3 = object;
                return object3;
            }
            finally {
                if (locked) {
                    this.singletonLock.unlock();
                }
            }
        }
        Object object = this.doGetObjectFromFactoryBean(factory, beanName);
        if (shouldPostProcess) {
            try {
                object = this.postProcessObjectFromFactoryBean(object, beanName);
            }
            catch (Throwable ex) {
                throw new BeanCreationException(beanName, "Post-processing of FactoryBean's object failed", ex);
            }
        }
        return object;
    }

    private Object doGetObjectFromFactoryBean(FactoryBean<?> factory, String beanName) throws BeanCreationException {
        Object object;
        try {
            object = factory.getObject();
        }
        catch (FactoryBeanNotInitializedException ex) {
            throw new BeanCurrentlyInCreationException(beanName, ex.toString());
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
        }
        if (object == null) {
            if (this.isSingletonCurrentlyInCreation(beanName)) {
                throw new BeanCurrentlyInCreationException(beanName, "FactoryBean which is currently in creation returned null from getObject");
            }
            object = new NullBean();
        }
        return object;
    }

    protected Object postProcessObjectFromFactoryBean(Object object, String beanName) throws BeansException {
        return object;
    }

    protected FactoryBean<?> getFactoryBean(String beanName, Object beanInstance) throws BeansException {
        if (!(beanInstance instanceof FactoryBean)) {
            throw new BeanCreationException(beanName, "Bean instance of type [" + String.valueOf(beanInstance.getClass()) + "] is not a FactoryBean");
        }
        FactoryBean factoryBean = (FactoryBean)beanInstance;
        return factoryBean;
    }

    @Override
    protected void removeSingleton(String beanName) {
        super.removeSingleton(beanName);
        this.factoryBeanObjectCache.remove(beanName);
    }

    @Override
    protected void clearSingletonCache() {
        super.clearSingletonCache();
        this.factoryBeanObjectCache.clear();
    }
}

