/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultListableBeanFactory
extends AbstractAutowireCapableBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry {
    private boolean allowBeanDefinitionOverriding = true;
    private boolean allowEagerClassLoading = true;
    private final Map beanDefinitionMap = new HashMap();
    private final List beanDefinitionNames = new ArrayList();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanCurrentlyInCreationException;

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public void setAllowEagerClassLoading(boolean allowEagerClassLoading) {
        this.allowEagerClassLoading = allowEagerClassLoading;
    }

    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        super.copyConfigurationFrom(otherFactory);
        if (otherFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory otherListableFactory = (DefaultListableBeanFactory)otherFactory;
            this.allowBeanDefinitionOverriding = otherListableFactory.allowBeanDefinitionOverriding;
            this.allowEagerClassLoading = otherListableFactory.allowEagerClassLoading;
        }
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.beanDefinitionMap.containsKey(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    public String[] getBeanDefinitionNames() {
        return StringUtils.toStringArray((Collection)this.beanDefinitionNames);
    }

    public String[] getBeanNamesForType(Class type) {
        return this.getBeanNamesForType(type, true, true);
    }

    public String[] getBeanNamesForType(Class type, boolean includePrototypes, boolean allowEagerInit) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = this.beanDefinitionNames.iterator();
        while (it.hasNext()) {
            RootBeanDefinition mbd;
            String beanName = (String)it.next();
            if (this.isAlias(beanName) || (mbd = this.getMergedBeanDefinition(beanName, false)).isAbstract() || !allowEagerInit && !mbd.hasBeanClass() && mbd.isLazyInit() && !this.allowEagerClassLoading) continue;
            try {
                boolean isFactoryBean = this.isBeanClassMatch(beanName, mbd, class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean);
                if (isFactoryBean || mbd.getFactoryBeanName() != null) {
                    if (allowEagerInit && (includePrototypes || this.isSingleton(beanName)) && this.isTypeMatch(beanName, type)) {
                        result.add(beanName);
                        continue;
                    }
                    if (!isFactoryBean) continue;
                    beanName = "&" + beanName;
                }
                if (!includePrototypes && !mbd.isSingleton() || !this.isTypeMatch(beanName, type)) continue;
                result.add(beanName);
            }
            catch (CannotLoadBeanClassException ex) {
                if (mbd.isLazyInit()) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Ignoring bean class loading failure for lazy-init bean '" + beanName + "'"), (Throwable)((Object)ex));
                    continue;
                }
                throw ex;
            }
        }
        String[] singletonNames = this.getSingletonNames();
        for (int i = 0; i < singletonNames.length; ++i) {
            String beanName = singletonNames[i];
            if (this.containsBeanDefinition(beanName)) continue;
            if (this.isFactoryBean(beanName)) {
                if ((includePrototypes || this.isSingleton(beanName)) && this.isTypeMatch(beanName, type)) {
                    result.add(beanName);
                    continue;
                }
                beanName = "&" + beanName;
            }
            if (!this.isTypeMatch(beanName, type)) continue;
            result.add(beanName);
        }
        return StringUtils.toStringArray(result);
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean allowEagerInit) throws BeansException {
        String[] beanNames = this.getBeanNamesForType(type, includePrototypes, allowEagerInit);
        Map result = CollectionFactory.createLinkedMapIfPossible((int)beanNames.length);
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            try {
                result.put(beanName, this.getBean(beanName));
                continue;
            }
            catch (BeanCreationException ex) {
                if (ex.contains(class$org$springframework$beans$factory$BeanCurrentlyInCreationException == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.BeanCurrentlyInCreationException") : class$org$springframework$beans$factory$BeanCurrentlyInCreationException)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Ignoring match to currently created bean '" + beanName + "': " + ex.getMessage()));
                    continue;
                }
                throw ex;
            }
        }
        return result;
    }

    public void preInstantiateSingletons() throws BeansException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Pre-instantiating singletons in factory [" + this + "]"));
        }
        Iterator it = this.beanDefinitionNames.iterator();
        while (it.hasNext()) {
            RootBeanDefinition bd;
            String beanName = (String)it.next();
            if (this.containsSingleton(beanName) || !this.containsBeanDefinition(beanName) || (bd = this.getMergedBeanDefinition(beanName, false)).isAbstract() || !bd.isSingleton() || bd.isLazyInit()) continue;
            Class beanClass = this.resolveBeanClass(bd, beanName);
            if (beanClass != null && (class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass)) {
                this.getBean("&" + beanName);
                continue;
            }
            this.getBean(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        Object oldBeanDefinition;
        Assert.hasText((String)beanName, (String)"'beanName' must not be empty");
        Assert.notNull((Object)beanDefinition, (String)"Bean definition must not be null");
        if (beanDefinition instanceof AbstractBeanDefinition) {
            try {
                ((AbstractBeanDefinition)beanDefinition).validate();
            }
            catch (BeanDefinitionValidationException ex) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Validation of bean definition failed", (Throwable)((Object)ex));
            }
        }
        if ((oldBeanDefinition = this.beanDefinitionMap.get(beanName)) != null) {
            if (!this.allowBeanDefinitionOverriding) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Cannot register bean definition [" + beanDefinition + "] for bean '" + beanName + "': there's already [" + oldBeanDefinition + "] bound");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Overriding bean definition for bean '" + beanName + "': replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]"));
            }
        } else {
            this.beanDefinitionNames.add(beanName);
        }
        this.beanDefinitionMap.put(beanName, beanDefinition);
        Object object = this.getSingletonMutex();
        synchronized (object) {
            this.removeSingleton(beanName);
        }
    }

    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        BeanDefinition bd = (BeanDefinition)this.beanDefinitionMap.get(beanName);
        if (bd == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No bean named '" + beanName + "' found in " + this.toString()));
            }
            throw new NoSuchBeanDefinitionException(beanName);
        }
        return bd;
    }

    protected Map findAutowireCandidates(String beanName, Class requiredType) {
        String[] candidateNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this, requiredType);
        Map result = CollectionFactory.createLinkedMapIfPossible((int)candidateNames.length);
        for (int i = 0; i < candidateNames.length; ++i) {
            String candidateName = candidateNames[i];
            if (candidateName.equals(beanName) || this.containsBeanDefinition(candidateName) && !this.getMergedBeanDefinition(candidateName).isAutowireCandidate()) continue;
            result.put(candidateName, this.getBean(candidateName));
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(" defining beans [");
        sb.append(StringUtils.arrayToDelimitedString((Object[])this.getBeanDefinitionNames(), (String)","));
        sb.append("]; ");
        if (this.getParentBeanFactory() == null) {
            sb.append("root of BeanFactory hierarchy");
        } else {
            sb.append("parent: " + this.getParentBeanFactory());
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

