/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util.matcher;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class RequestHeaderRequestMatcher
implements RequestMatcher {
    private final String expectedHeaderName;
    private final @Nullable String expectedHeaderValue;

    public RequestHeaderRequestMatcher(String expectedHeaderName) {
        this(expectedHeaderName, null);
    }

    public RequestHeaderRequestMatcher(String expectedHeaderName, @Nullable String expectedHeaderValue) {
        Assert.notNull((Object)expectedHeaderName, (String)"headerName cannot be null");
        this.expectedHeaderName = expectedHeaderName;
        this.expectedHeaderValue = expectedHeaderValue;
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        String actualHeaderValue = request.getHeader(this.expectedHeaderName);
        if (this.expectedHeaderValue == null) {
            return actualHeaderValue != null;
        }
        return this.expectedHeaderValue.equals(actualHeaderValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RequestHeaderRequestMatcher)) {
            return false;
        }
        RequestHeaderRequestMatcher that = (RequestHeaderRequestMatcher)obj;
        return Objects.equals(this.expectedHeaderName, that.expectedHeaderName) && Objects.equals(this.expectedHeaderValue, that.expectedHeaderValue);
    }

    public int hashCode() {
        return Objects.hash(this.expectedHeaderName, this.expectedHeaderValue);
    }

    public String toString() {
        return "RequestHeaderRequestMatcher [expectedHeaderName=" + this.expectedHeaderName + ", expectedHeaderValue=" + this.expectedHeaderValue + "]";
    }
}

