/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication.ott;

import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.ott.OneTimeToken;
import org.springframework.security.authentication.ott.reactive.ReactiveOneTimeTokenService;
import org.springframework.security.web.server.authentication.ott.DefaultServerGenerateOneTimeTokenRequestResolver;
import org.springframework.security.web.server.authentication.ott.ServerGenerateOneTimeTokenRequestResolver;
import org.springframework.security.web.server.authentication.ott.ServerOneTimeTokenGenerationSuccessHandler;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public final class GenerateOneTimeTokenWebFilter
implements WebFilter {
    private final ReactiveOneTimeTokenService oneTimeTokenService;
    private ServerWebExchangeMatcher matcher = ServerWebExchangeMatchers.pathMatchers(HttpMethod.POST, "/ott/generate");
    private ServerGenerateOneTimeTokenRequestResolver generateRequestResolver = new DefaultServerGenerateOneTimeTokenRequestResolver();
    private final ServerOneTimeTokenGenerationSuccessHandler oneTimeTokenGenerationSuccessHandler;

    public GenerateOneTimeTokenWebFilter(ReactiveOneTimeTokenService oneTimeTokenService, ServerOneTimeTokenGenerationSuccessHandler oneTimeTokenGenerationSuccessHandler) {
        Assert.notNull((Object)oneTimeTokenGenerationSuccessHandler, (String)"oneTimeTokenGenerationSuccessHandler cannot be null");
        Assert.notNull((Object)oneTimeTokenService, (String)"oneTimeTokenService cannot be null");
        this.oneTimeTokenGenerationSuccessHandler = oneTimeTokenGenerationSuccessHandler;
        this.oneTimeTokenService = oneTimeTokenService;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.matcher.matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).flatMap(result -> this.generateRequestResolver.resolve(exchange)).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(arg_0 -> ((ReactiveOneTimeTokenService)this.oneTimeTokenService).generate(arg_0)).flatMap(token -> this.oneTimeTokenGenerationSuccessHandler.handle(exchange, (OneTimeToken)token));
    }

    public void setRequestMatcher(ServerWebExchangeMatcher matcher) {
        Assert.notNull((Object)matcher, (String)"matcher cannot be null");
        this.matcher = matcher;
    }

    public void setGenerateRequestResolver(ServerGenerateOneTimeTokenRequestResolver requestResolver) {
        Assert.notNull((Object)requestResolver, (String)"requestResolver cannot be null");
        this.generateRequestResolver = requestResolver;
    }
}

