/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.jackson;

import org.springframework.security.oauth2.client.jackson.JsonNodeUtils;
import org.springframework.security.oauth2.core.AuthenticationMethod;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.util.StdConverter;

abstract class StdConverters {
    StdConverters() {
    }

    static final class AuthenticationMethodConverter
    extends StdConverter<JsonNode, AuthenticationMethod> {
        AuthenticationMethodConverter() {
        }

        public AuthenticationMethod convert(JsonNode jsonNode) {
            String value = JsonNodeUtils.findStringValue(jsonNode, "value");
            if (AuthenticationMethod.HEADER.getValue().equalsIgnoreCase(value)) {
                return AuthenticationMethod.HEADER;
            }
            if (AuthenticationMethod.FORM.getValue().equalsIgnoreCase(value)) {
                return AuthenticationMethod.FORM;
            }
            if (AuthenticationMethod.QUERY.getValue().equalsIgnoreCase(value)) {
                return AuthenticationMethod.QUERY;
            }
            return null;
        }
    }

    static final class AuthorizationGrantTypeConverter
    extends StdConverter<JsonNode, AuthorizationGrantType> {
        AuthorizationGrantTypeConverter() {
        }

        public AuthorizationGrantType convert(JsonNode jsonNode) {
            String value = JsonNodeUtils.findStringValue(jsonNode, "value");
            if (AuthorizationGrantType.AUTHORIZATION_CODE.getValue().equalsIgnoreCase(value)) {
                return AuthorizationGrantType.AUTHORIZATION_CODE;
            }
            if (AuthorizationGrantType.CLIENT_CREDENTIALS.getValue().equalsIgnoreCase(value)) {
                return AuthorizationGrantType.CLIENT_CREDENTIALS;
            }
            return new AuthorizationGrantType(value);
        }
    }

    static final class ClientAuthenticationMethodConverter
    extends StdConverter<JsonNode, ClientAuthenticationMethod> {
        ClientAuthenticationMethodConverter() {
        }

        public ClientAuthenticationMethod convert(JsonNode jsonNode) {
            String value = JsonNodeUtils.findStringValue(jsonNode, "value");
            return ClientAuthenticationMethod.valueOf((String)value);
        }
    }

    static final class AccessTokenTypeConverter
    extends StdConverter<JsonNode, OAuth2AccessToken.TokenType> {
        AccessTokenTypeConverter() {
        }

        public OAuth2AccessToken.TokenType convert(JsonNode jsonNode) {
            String value = JsonNodeUtils.findStringValue(jsonNode, "value");
            if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(value)) {
                return OAuth2AccessToken.TokenType.BEARER;
            }
            return null;
        }
    }
}

