/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.util.LinkedList;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.mail.MailReceiver;
import org.springframework.integration.mail.MailTransportUtils;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public abstract class AbstractMailReceiver
extends IntegrationObjectSupport
implements MailReceiver,
DisposableBean {
    public static final String SI_USER_FLAG = "spring-integration-mail-adapter";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final URLName url;
    private volatile String protocol;
    private volatile int maxFetchSize = -1;
    private volatile Session session;
    private volatile Store store;
    private volatile Folder folder;
    private volatile boolean shouldDeleteMessages;
    protected volatile int folderOpenMode = 1;
    private volatile Properties javaMailProperties = new Properties();
    private volatile Authenticator javaMailAuthenticator;
    private volatile StandardEvaluationContext evaluationContext;
    private volatile Expression selectorExpression;
    protected volatile boolean initialized;
    private final Object folderMonitor = new Object();

    public AbstractMailReceiver() {
        this.url = null;
    }

    public AbstractMailReceiver(URLName urlName) {
        Assert.notNull((Object)urlName, (String)"urlName must not be null");
        this.url = urlName;
    }

    public AbstractMailReceiver(String url) {
        this.url = url != null ? new URLName(url) : null;
    }

    public void setSelectorExpression(Expression selectorExpression) {
        this.selectorExpression = selectorExpression;
    }

    public void setProtocol(String protocol) {
        if (this.url != null) {
            Assert.isTrue((boolean)this.url.getProtocol().equals(protocol), (String)"The 'protocol' does not match that provided by the Store URI.");
        }
        this.protocol = protocol;
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public void setJavaMailAuthenticator(Authenticator javaMailAuthenticator) {
        this.javaMailAuthenticator = javaMailAuthenticator;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public void setShouldDeleteMessages(boolean shouldDeleteMessages) {
        this.shouldDeleteMessages = shouldDeleteMessages;
    }

    protected boolean shouldDeleteMessages() {
        return this.shouldDeleteMessages;
    }

    protected Folder getFolder() {
        return this.folder;
    }

    protected abstract Message[] searchForNewMessages() throws javax.mail.MessagingException;

    private void openSession() throws javax.mail.MessagingException {
        if (this.session == null) {
            this.session = this.javaMailAuthenticator != null ? Session.getInstance((Properties)this.javaMailProperties, (Authenticator)this.javaMailAuthenticator) : Session.getInstance((Properties)this.javaMailProperties);
        }
        if (this.store == null) {
            this.store = this.url != null ? this.session.getStore(this.url) : (this.protocol != null ? this.session.getStore(this.protocol) : this.session.getStore());
        }
        if (!this.store.isConnected()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("connecting to store [" + MailTransportUtils.toPasswordProtectedString(this.url) + "]"));
            }
            this.store.connect();
        }
    }

    protected void openFolder() throws javax.mail.MessagingException {
        this.openSession();
        if (this.folder == null) {
            this.folder = this.obtainFolderInstance();
        }
        if (this.folder == null || !this.folder.exists()) {
            throw new IllegalStateException("no such folder [" + this.url.getFile() + "]");
        }
        if (this.folder.isOpen()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("opening folder [" + MailTransportUtils.toPasswordProtectedString(this.url) + "]"));
        }
        this.folder.open(this.folderOpenMode);
    }

    private Folder obtainFolderInstance() throws javax.mail.MessagingException {
        return this.store.getFolder(this.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message[] receive() throws javax.mail.MessagingException {
        Object object = this.folderMonitor;
        synchronized (object) {
            Message[] messageArray;
            try {
                this.openFolder();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("attempting to receive mail from folder [" + this.getFolder().getFullName() + "]"));
                }
                Message[] messages = this.searchForNewMessages();
                if (this.maxFetchSize > 0 && messages.length > this.maxFetchSize) {
                    Message[] reducedMessages = new Message[this.maxFetchSize];
                    System.arraycopy(messages, 0, reducedMessages, 0, this.maxFetchSize);
                    messages = reducedMessages;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("found " + messages.length + " new messages"));
                }
                if (messages.length > 0) {
                    this.fetchMessages(messages);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Received " + messages.length + " messages"));
                }
                Message[] filteredMessages = this.filterMessagesThruSelector(messages);
                this.postProcessFilteredMessages(filteredMessages);
                messageArray = filteredMessages;
            }
            catch (Throwable throwable) {
                MailTransportUtils.closeFolder(this.folder, this.shouldDeleteMessages);
                throw throwable;
            }
            MailTransportUtils.closeFolder(this.folder, this.shouldDeleteMessages);
            return messageArray;
        }
    }

    private void postProcessFilteredMessages(Message[] filteredMessages) throws javax.mail.MessagingException {
        this.setMessageFlags(filteredMessages);
        if (this.shouldDeleteMessages()) {
            this.deleteMessages(filteredMessages);
        }
        for (int i = 0; i < filteredMessages.length; ++i) {
            IntegrationMimeMessage mimeMessage = new IntegrationMimeMessage((MimeMessage)filteredMessages[i]);
            filteredMessages[i] = mimeMessage;
        }
    }

    private void setMessageFlags(Message[] filteredMessages) throws javax.mail.MessagingException {
        boolean recentFlagSupported = false;
        Flags flags = this.getFolder().getPermanentFlags();
        if (flags != null) {
            recentFlagSupported = flags.contains(Flags.Flag.RECENT);
        }
        for (Message message : filteredMessages) {
            if (!recentFlagSupported) {
                if (flags != null && flags.contains(Flags.Flag.USER)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"USER flags are supported by this mail server. Flagging message with 'spring-integration-mail-adapter' user flag");
                    }
                    Flags siFlags = new Flags();
                    siFlags.add(SI_USER_FLAG);
                    message.setFlags(siFlags, true);
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"USER flags are not supported by this mail server. Flagging message with system flag");
                    }
                    message.setFlag(Flags.Flag.FLAGGED, true);
                }
            }
            this.setAdditionalFlags(message);
        }
    }

    private Message[] filterMessagesThruSelector(Message[] messages) throws javax.mail.MessagingException {
        LinkedList<MimeMessage> filteredMessages = new LinkedList<MimeMessage>();
        for (int i = 0; i < messages.length; ++i) {
            MimeMessage message = (MimeMessage)messages[i];
            if (this.selectorExpression != null) {
                if (((Boolean)this.selectorExpression.getValue((EvaluationContext)this.evaluationContext, (Object)message, Boolean.class)).booleanValue()) {
                    filteredMessages.add(message);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Fetched email with subject '" + message.getSubject() + "' will be discarded by the matching filter" + " and will not be flagged as SEEN."));
                continue;
            }
            filteredMessages.add(message);
        }
        return filteredMessages.toArray(new Message[filteredMessages.size()]);
    }

    protected void fetchMessages(Message[] messages) throws javax.mail.MessagingException {
        FetchProfile contentsProfile = new FetchProfile();
        contentsProfile.add(FetchProfile.Item.ENVELOPE);
        contentsProfile.add(FetchProfile.Item.CONTENT_INFO);
        contentsProfile.add(FetchProfile.Item.FLAGS);
        this.folder.fetch(messages, contentsProfile);
    }

    protected void deleteMessages(Message[] messages) throws javax.mail.MessagingException {
        for (int i = 0; i < messages.length; ++i) {
            messages[i].setFlag(Flags.Flag.DELETED, true);
        }
    }

    protected void setAdditionalFlags(Message message) throws javax.mail.MessagingException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        Object object = this.folderMonitor;
        synchronized (object) {
            MailTransportUtils.closeFolder(this.folder, this.shouldDeleteMessages);
            MailTransportUtils.closeService((Service)this.store);
            this.folder = null;
            this.store = null;
            this.initialized = false;
        }
    }

    protected void onInit() throws Exception {
        super.onInit();
        this.folderOpenMode = 2;
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        this.initialized = true;
    }

    public String toString() {
        return this.url.toString();
    }

    Store getStore() {
        return this.store;
    }

    private class IntegrationMimeMessage
    extends MimeMessage {
        public IntegrationMimeMessage(MimeMessage source) throws javax.mail.MessagingException {
            super(source);
        }

        public Folder getFolder() {
            try {
                return AbstractMailReceiver.this.obtainFolderInstance();
            }
            catch (javax.mail.MessagingException e) {
                throw new MessagingException("Unable to obtain the mail folder", (Throwable)e);
            }
        }
    }
}

