/*
 * Copyright 2018-2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.hateoas.mediatype.uber;

import java.util.List;
import java.util.Objects;

import org.springframework.lang.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * {@literal UBER+JSON} representation of an error.
 *
 * @author Greg Turnquist
 * @since 1.0
 */
final class UberError {

	private final List<UberData> data;

	@JsonCreator
	UberError(@JsonProperty("data") @Nullable List<UberData> data) {
		this.data = data;
	}

	UberError() {
		this(null);
	}

	UberError withData(List<UberData> data) {
		return this.data == data ? this : new UberError(data);
	}

	public List<UberData> getData() {
		return this.data;
	}

	@Override
	public boolean equals(Object o) {

		if (this == o)
			return true;
		if (!(o instanceof UberError))
			return false;
		UberError uberError = (UberError) o;
		return Objects.equals(this.data, uberError.data);
	}

	@Override
	public int hashCode() {
		return Objects.hash(this.data);
	}

	public String toString() {
		return "UberError(data=" + this.data + ")";
	}
}
