/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.Map;
import java.util.Optional;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class ControllerUtils {
    public static <R extends RepresentationModel<?>> ResponseEntity<RepresentationModel<?>> toResponseEntity(HttpStatus status, HttpHeaders headers, Optional<R> resource) {
        HttpHeaders hdrs = new HttpHeaders();
        if (headers != null) {
            hdrs.putAll((Map)headers);
        }
        return new ResponseEntity((Object)resource.orElse(null), (MultiValueMap)hdrs, (HttpStatusCode)status);
    }

    public static <R extends RepresentationModel<?>> ResponseEntity<RepresentationModel<?>> toResponseEntity(HttpStatus status, HttpHeaders headers, R resource) {
        Assert.notNull((Object)status, (String)"Http status must not be null");
        Assert.notNull((Object)headers, (String)"Http headers must not be null");
        Assert.notNull(resource, (String)"Payload must not be null");
        return ControllerUtils.toResponseEntity(status, headers, Optional.of(resource));
    }

    public static ResponseEntity<RepresentationModel<?>> toEmptyResponse(HttpStatus status) {
        return ControllerUtils.toEmptyResponse(status, new HttpHeaders());
    }

    public static ResponseEntity<RepresentationModel<?>> toEmptyResponse(HttpStatus status, HttpHeaders headers) {
        return ControllerUtils.toResponseEntity(status, headers, Optional.empty());
    }

    static Link getDefaultSelfLink() {
        return Link.of((String)ServletUriComponentsBuilder.fromCurrentRequest().build().toUriString());
    }
}

