/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.util.Assert;

class MappedProperties {
    private static final ClassIntrospector INTROSPECTOR = new BasicClassIntrospector();
    private final Map<PersistentProperty<?>, BeanPropertyDefinition> propertyToFieldName;
    private final Map<String, PersistentProperty<?>> fieldNameToProperty;
    private final Set<BeanPropertyDefinition> unmappedProperties;

    private MappedProperties(PersistentEntity<?, ? extends PersistentProperty<?>> entity, BeanDescription description) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        Assert.notNull((Object)description, (String)"BeanDescription must not be null!");
        this.propertyToFieldName = new HashMap();
        this.fieldNameToProperty = new HashMap();
        this.unmappedProperties = new HashSet<BeanPropertyDefinition>();
        for (BeanPropertyDefinition property : description.findProperties()) {
            if (description.getIgnoredPropertyNames().contains(property.getName())) continue;
            Optional<PersistentProperty> persistentProperty = Optional.ofNullable(entity.getPersistentProperty(property.getInternalName()));
            persistentProperty.ifPresent(it -> {
                this.propertyToFieldName.put((PersistentProperty<?>)it, property);
                this.fieldNameToProperty.put(property.getName(), (PersistentProperty<?>)it);
            });
            if (persistentProperty.isPresent()) continue;
            this.unmappedProperties.add(property);
        }
    }

    public static MappedProperties fromJacksonProperties(PersistentEntity<?, ?> entity, ObjectMapper mapper) {
        BeanDescription description = INTROSPECTOR.forDeserialization(mapper.getDeserializationConfig(), mapper.constructType((Type)entity.getType()), (ClassIntrospector.MixInResolver)mapper.getDeserializationConfig());
        return new MappedProperties(entity, description);
    }

    public static MappedProperties none() {
        return new MappedProperties(Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet());
    }

    public String getMappedName(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        return this.propertyToFieldName.get(property).getName();
    }

    public boolean hasPersistentPropertyForField(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field name must not be null or empty!");
        return this.fieldNameToProperty.containsKey(fieldName);
    }

    public PersistentProperty<?> getPersistentProperty(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field name must not be null or empty!");
        return this.fieldNameToProperty.get(fieldName);
    }

    public Iterable<String> getSpringDataUnmappedProperties() {
        if (this.unmappedProperties.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<String> result = new ArrayList<String>(this.unmappedProperties.size());
        for (BeanPropertyDefinition definitions : this.unmappedProperties) {
            result.add(definitions.getInternalName());
        }
        return result;
    }

    public boolean isMappedProperty(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        return this.propertyToFieldName.containsKey(property);
    }

    private MappedProperties(Map<PersistentProperty<?>, BeanPropertyDefinition> propertyToFieldName, Map<String, PersistentProperty<?>> fieldNameToProperty, Set<BeanPropertyDefinition> unmappedProperties) {
        this.propertyToFieldName = propertyToFieldName;
        this.fieldNameToProperty = fieldNameToProperty;
        this.unmappedProperties = unmappedProperties;
    }
}

