/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;

public class BaseUri {
    public static final BaseUri NONE = new BaseUri(URI.create(""));
    private static final UrlPathHelper URL_PATH_HELPER = new UrlPathHelper();
    private final URI baseUri;

    public BaseUri(URI uri) {
        Assert.notNull((Object)uri, (String)"Base URI must not be null!");
        String uriString = uri.toString();
        this.baseUri = URI.create(StringUtils.trimTrailingCharacter((String)StringUtils.trimTrailingCharacter((String)uriString, (char)'/'), (char)'/'));
    }

    public BaseUri(String uri) {
        this(URI.create(uri));
    }

    public URI getUri() {
        return this.baseUri;
    }

    public String getRepositoryLookupPath(NativeWebRequest request) {
        return this.getRepositoryLookupPath((HttpServletRequest)request.getNativeRequest(HttpServletRequest.class));
    }

    private String getRepositoryLookupPath(HttpServletRequest request) {
        String lookupPath = URL_PATH_HELPER.getLookupPathForRequest(request);
        return this.getRepositoryLookupPath(lookupPath);
    }

    public String getRepositoryLookupPath(String lookupPath) {
        Assert.notNull((Object)lookupPath, (String)"Lookup path must not be null!");
        lookupPath = lookupPath.replaceAll("//", "/");
        lookupPath = StringUtils.trimTrailingCharacter((String)lookupPath, (char)'/');
        if (!this.baseUri.isAbsolute()) {
            String uri = this.baseUri.toString();
            if (!StringUtils.hasText((String)uri)) {
                return lookupPath;
            }
            uri = uri.startsWith("/") ? uri : "/".concat(uri);
            return lookupPath.startsWith(uri) ? lookupPath.substring(uri.length(), lookupPath.length()) : null;
        }
        List baseUriSegments = UriComponentsBuilder.fromUri((URI)this.baseUri).build().getPathSegments();
        Collections.reverse(baseUriSegments);
        String tail = "";
        for (String tailSegment : baseUriSegments) {
            tail = "/".concat(tailSegment).concat(tail);
            if (!lookupPath.startsWith(tail)) continue;
            return lookupPath.substring(tail.length(), lookupPath.length());
        }
        return null;
    }

    public UriComponentsBuilder getUriComponentsBuilder() {
        if (this.baseUri.isAbsolute()) {
            return UriComponentsBuilder.fromUri((URI)this.baseUri);
        }
        return ServletUriComponentsBuilder.fromCurrentServletMapping().path(this.baseUri.toString());
    }
}

