/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public interface MappingPolicy {
    public static final MappingPolicy LOAD_POLICY = new DefaultMappingPolicy(Option.SHOULD_LOAD);
    public static final MappingPolicy DEFAULT_POLICY = new DefaultMappingPolicy(new Option[0]);
    public static final MappingPolicy MAP_FIELD_DIRECT_POLICY = new DefaultMappingPolicy(Option.FIELD_DIRECT);

    public boolean accessField();

    public boolean shouldLoad();

    public MappingPolicy combineWith(MappingPolicy var1);

    public static class DefaultMappingPolicy
    implements MappingPolicy,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Set<Option> options;

        public DefaultMappingPolicy(Option ... options) {
            this(Arrays.asList(options));
        }

        public DefaultMappingPolicy(Collection<Option> options) {
            this.options = options.isEmpty() ? EnumSet.noneOf(Option.class) : EnumSet.copyOf(options);
        }

        @Override
        public boolean accessField() {
            return this.options.contains((Object)Option.FIELD_DIRECT);
        }

        @Override
        public boolean shouldLoad() {
            return this.options.contains((Object)Option.SHOULD_LOAD);
        }

        public MappingPolicy with(Option ... options) {
            return this.with(Arrays.asList(options));
        }

        private MappingPolicy with(Collection<Option> optionsList) {
            HashSet<Option> combined = new HashSet<Option>(optionsList);
            combined.addAll(this.options);
            combined.remove(null);
            return new DefaultMappingPolicy(combined);
        }

        public MappingPolicy withOut(Option ... options) {
            HashSet<Option> combined = new HashSet<Option>(this.options);
            combined.removeAll(Arrays.asList(options));
            return new DefaultMappingPolicy(combined);
        }

        @Override
        public MappingPolicy combineWith(MappingPolicy mappingPolicy) {
            if (mappingPolicy instanceof DefaultMappingPolicy) {
                return this.with(((DefaultMappingPolicy)mappingPolicy).options);
            }
            return this.with(mappingPolicy.accessField() ? Option.FIELD_DIRECT : null, mappingPolicy.shouldLoad() ? Option.SHOULD_LOAD : null);
        }

        public String toString() {
            return "Policy: " + this.options.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultMappingPolicy that = (DefaultMappingPolicy)o;
            return ((Object)this.options).equals(that.options);
        }

        public int hashCode() {
            return ((Object)this.options).hashCode();
        }
    }

    public static enum Option {
        FIELD_DIRECT,
        SHOULD_LOAD;

    }
}

