/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.domain.VectorScoringFunctions;

public class SimilarityNormalizer {
    public static final SimilarityNormalizer IDENTITY = new SimilarityNormalizer(ScoringFunction.unspecified(), DoubleUnaryOperator.identity(), DoubleUnaryOperator.identity());
    public static final SimilarityNormalizer EUCLIDEAN = new SimilarityNormalizer((ScoringFunction)VectorScoringFunctions.EUCLIDEAN, it -> 1.0 / (1.0 + Math.pow(it, 2.0)), it -> it == 0.0 ? 3.4028234663852886E38 : Math.sqrt(1.0 / it - 1.0));
    public static final SimilarityNormalizer COSINE = new SimilarityNormalizer((ScoringFunction)VectorScoringFunctions.COSINE, it -> (1.0 + (1.0 - it)) / 2.0, it -> 1.0 - (it * 2.0 - 1.0));
    public static final SimilarityNormalizer DOT_PRODUCT = new SimilarityNormalizer((ScoringFunction)VectorScoringFunctions.DOT_PRODUCT, it -> (1.0 - it) / 2.0, it -> 1.0 - it * 2.0);
    private static final Map<ScoringFunction, SimilarityNormalizer> NORMALIZERS = new HashMap<ScoringFunction, SimilarityNormalizer>();
    private final ScoringFunction scoringFunction;
    private final DoubleUnaryOperator similarity;
    private final DoubleUnaryOperator score;

    static {
        NORMALIZERS.put(SimilarityNormalizer.EUCLIDEAN.scoringFunction, EUCLIDEAN);
        NORMALIZERS.put(SimilarityNormalizer.COSINE.scoringFunction, COSINE);
        NORMALIZERS.put(SimilarityNormalizer.DOT_PRODUCT.scoringFunction, DOT_PRODUCT);
    }

    SimilarityNormalizer(ScoringFunction scoringFunction, DoubleUnaryOperator similarity, DoubleUnaryOperator score) {
        this.scoringFunction = scoringFunction;
        this.score = score;
        this.similarity = similarity;
    }

    public static SimilarityNormalizer get(ScoringFunction scoringFunction) {
        SimilarityNormalizer normalizer = NORMALIZERS.get(scoringFunction);
        if (normalizer == null) {
            throw new IllegalArgumentException("No SimilarityNormalizer found for " + scoringFunction.getName());
        }
        return normalizer;
    }

    public double getSimilarity(double score) {
        return this.similarity.applyAsDouble(score);
    }

    public double getScore(double similarity) {
        return this.score.applyAsDouble(similarity);
    }

    public String toString() {
        return "%s Normalizer: Similarity[0 to 1] -> Score[%f to %f]".formatted(this.scoringFunction.getName(), this.getScore(0.0), this.getScore(1.0));
    }
}

