/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.repository.query.parser.Property;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaQueryCreator
extends AbstractQueryCreator<CriteriaQuery<Object>, Predicate> {
    private final CriteriaBuilder builder;
    private final Root<?> root;
    private final CriteriaQuery<Object> query;
    private final ParameterExpressionProvider provider;

    public JpaQueryCreator(PartTree tree, Class<?> domainClass, Parameters parameters, EntityManager em) {
        super(tree);
        this.builder = em.getCriteriaBuilder();
        this.query = this.builder.createQuery().distinct(tree.isDistinct());
        this.root = this.query.from(domainClass);
        this.provider = new ParameterExpressionProvider(this.builder, parameters.getBindableParameters());
    }

    public List<ParameterExpression<?>> getParameterExpressions() {
        return this.provider.getExpressions();
    }

    protected Predicate create(Part part, Iterator<Object> iterator) {
        return this.toPredicate(part, this.root);
    }

    protected Predicate and(Part part, Predicate base, Iterator<Object> iterator) {
        return this.builder.and((Expression)base, (Expression)this.toPredicate(part, this.root));
    }

    protected Predicate or(Predicate base, Predicate predicate) {
        return this.builder.or((Expression)base, (Expression)predicate);
    }

    protected final CriteriaQuery<Object> complete(Predicate predicate, Sort sort) {
        return this.complete(predicate, sort, this.query, this.builder, this.root);
    }

    protected CriteriaQuery<Object> complete(Predicate predicate, Sort sort, CriteriaQuery<Object> query, CriteriaBuilder builder, Root<?> root) {
        return this.query.select(root).where((Expression)predicate).orderBy(QueryUtils.toOrders(sort, root, builder));
    }

    private Predicate toPredicate(Part part, Root<?> root) {
        Property property = part.getProperty();
        Expression path = this.toExpressionRecursively((From<?, ?>)root, property);
        switch (part.getType()) {
            case BETWEEN: {
                ParameterExpression first = this.provider.next();
                ParameterExpression second = this.provider.next();
                return this.builder.between(this.getComparablePath(root, part), first, second);
            }
            case GREATER_THAN: {
                return this.builder.greaterThan(this.getComparablePath(root, part), this.provider.next(Comparable.class));
            }
            case LESS_THAN: {
                return this.builder.lessThan(this.getComparablePath(root, part), this.provider.next(Comparable.class));
            }
            case IS_NULL: {
                return path.isNull();
            }
            case IS_NOT_NULL: {
                return path.isNotNull();
            }
            case NOT_IN: {
                return path.in(new Expression[]{this.provider.next(Collection.class)}).not();
            }
            case IN: {
                return path.in(new Expression[]{this.provider.next(Collection.class)});
            }
            case LIKE: {
                return this.builder.like(this.getTypedPath(root, part, String.class), this.provider.next(String.class));
            }
            case NOT_LIKE: {
                return this.builder.like(this.getTypedPath(root, part, String.class), this.provider.next(String.class)).not();
            }
            case SIMPLE_PROPERTY: {
                return this.builder.equal(path, this.provider.next());
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return this.builder.notEqual(path, this.provider.next());
            }
        }
        throw new IllegalArgumentException("Unsupported keyword + " + part.getType());
    }

    private Expression<Object> toExpressionRecursively(Path<Object> path, Property property) {
        Expression<Object> result = path.get(property.getName());
        return property.hasNext() ? this.toExpressionRecursively((Path<Object>)result, property.next()) : result;
    }

    private <T> Expression<T> toExpressionRecursively(From<?, ?> from, Property property) {
        if (property.isCollection()) {
            Expression<T> join = from.join(property.getName());
            return property.hasNext() ? this.toExpressionRecursively((From<?, ?>)join, property.next()) : join;
        }
        Expression<Object> path = from.get(property.getName());
        return property.hasNext() ? this.toExpressionRecursively((Path<Object>)path, property.next()) : path;
    }

    private Expression<? extends Comparable> getComparablePath(Root<?> root, Part part) {
        return this.getTypedPath(root, part, Comparable.class);
    }

    private <T> Expression<T> getTypedPath(Root<?> root, Part part, Class<T> type) {
        return this.toExpressionRecursively((From<?, ?>)root, part.getProperty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterExpressionProvider {
        private final CriteriaBuilder builder;
        private final Iterator<Parameter> parameters;
        private final List<ParameterExpression<?>> expressions;

        public ParameterExpressionProvider(CriteriaBuilder builder, Parameters parameters) {
            Assert.notNull((Object)builder);
            Assert.notNull((Object)parameters);
            this.builder = builder;
            this.parameters = parameters.iterator();
            this.expressions = new ArrayList();
        }

        public List<ParameterExpression<?>> getExpressions() {
            return Collections.unmodifiableList(this.expressions);
        }

        public <T> ParameterExpression<T> next() {
            Parameter parameter = this.parameters.next();
            return this.next(parameter.getType(), parameter.getName());
        }

        public <T> ParameterExpression<T> next(Class<T> type) {
            this.parameters.next();
            return this.next(type, null);
        }

        private <T> ParameterExpression<T> next(Class<T> type, String name) {
            Assert.notNull(type);
            ParameterExpression expression = name == null ? this.builder.parameter(type) : this.builder.parameter(type, name);
            this.expressions.add(expression);
            return expression;
        }
    }
}

