/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.auditing;

import java.lang.reflect.Field;
import java.util.Calendar;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.auditing.AnnotationAuditingMetadata;
import org.springframework.data.auditing.AuditableBeanWrapper;
import org.springframework.data.domain.Auditable;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class AuditableBeanWrapperFactory {
    AuditableBeanWrapperFactory() {
    }

    public AuditableBeanWrapper getBeanWrapperFor(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Auditable) {
            return new AuditableInterfaceBeanWrapper((Auditable)source);
        }
        AnnotationAuditingMetadata metadata = AnnotationAuditingMetadata.getMetadata(source.getClass());
        if (metadata.isAuditable()) {
            return new ReflectionAuditingBeanWrapper(source);
        }
        return null;
    }

    private static enum CalendarToLocalDateTimeConverter implements Converter<Calendar, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(Calendar source) {
            return new LocalDateTime((Object)source);
        }
    }

    private static enum CalendarToDateTimeConverter implements Converter<Calendar, DateTime>
    {
        INSTANCE;


        public DateTime convert(Calendar source) {
            return new DateTime((Object)source);
        }
    }

    static class ReflectionAuditingBeanWrapper
    extends DateConvertingAuditableBeanWrapper {
        private final AnnotationAuditingMetadata metadata;
        private final Object target;

        public ReflectionAuditingBeanWrapper(Object target) {
            Assert.notNull((Object)target, (String)"Target object must not be null!");
            this.metadata = AnnotationAuditingMetadata.getMetadata(target.getClass());
            this.target = target;
        }

        @Override
        public void setCreatedBy(Object value) {
            this.setField(this.metadata.getCreatedByField(), value);
        }

        @Override
        public void setCreatedDate(Calendar value) {
            this.setDateField(this.metadata.getCreatedDateField(), value);
        }

        @Override
        public void setLastModifiedBy(Object value) {
            this.setField(this.metadata.getLastModifiedByField(), value);
        }

        @Override
        public void setLastModifiedDate(Calendar value) {
            this.setDateField(this.metadata.getLastModifiedDateField(), value);
        }

        private void setField(Field field, Object value) {
            if (field != null) {
                ReflectionUtils.setField(field, this.target, value);
            }
        }

        private void setDateField(Field field, Calendar value) {
            if (field == null) {
                return;
            }
            ReflectionUtils.setField(field, this.target, this.getDateValueToSet(value, field.getType(), field));
        }
    }

    static abstract class DateConvertingAuditableBeanWrapper
    implements AuditableBeanWrapper {
        private static boolean IS_JODA_TIME_PRESENT = ClassUtils.isPresent((String)"org.joda.time.DateTime", (ClassLoader)ReflectionAuditingBeanWrapper.class.getClassLoader());
        private final ConversionService conversionService;

        public DateConvertingAuditableBeanWrapper() {
            DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
            if (IS_JODA_TIME_PRESENT) {
                conversionService.addConverter((Converter)CalendarToDateTimeConverter.INSTANCE);
                conversionService.addConverter((Converter)CalendarToLocalDateTimeConverter.INSTANCE);
            }
            this.conversionService = conversionService;
        }

        protected Object getDateValueToSet(Calendar value, Class<?> targetType, Object source) {
            if (value == null) {
                return null;
            }
            if (Calendar.class.equals(targetType)) {
                return value;
            }
            if (this.conversionService.canConvert(Calendar.class, targetType)) {
                return this.conversionService.convert((Object)value, targetType);
            }
            throw new IllegalArgumentException(String.format("Invalid date type for member %s! Supported types are %s.", source, AnnotationAuditingMetadata.SUPPORTED_DATE_TYPES));
        }
    }

    static class AuditableInterfaceBeanWrapper
    implements AuditableBeanWrapper {
        private final Auditable<Object, ?> auditable;

        public AuditableInterfaceBeanWrapper(Auditable<Object, ?> auditable) {
            this.auditable = auditable;
        }

        @Override
        public void setCreatedBy(Object value) {
            this.auditable.setCreatedBy(value);
        }

        @Override
        public void setCreatedDate(Calendar value) {
            this.auditable.setCreatedDate(new DateTime((Object)value));
        }

        @Override
        public void setLastModifiedBy(Object value) {
            this.auditable.setLastModifiedBy(value);
        }

        @Override
        public void setLastModifiedDate(Calendar value) {
            this.auditable.setLastModifiedDate(new DateTime((Object)value));
        }
    }
}

