/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.servlet.ServletRequest;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefaults;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.context.request.NativeWebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageableArgumentResolver
implements WebArgumentResolver {
    private static final Pageable DEFAULT_PAGE_REQUEST = new PageRequest(0, 10);
    private static final String DEFAULT_PREFIX = "page";
    private static final String DEFAULT_SEPARATOR = ".";
    private Pageable fallbackPagable = DEFAULT_PAGE_REQUEST;
    private String prefix = "page";
    private String separator = ".";

    public void setFallbackPagable(Pageable fallbackPagable) {
        this.fallbackPagable = null == fallbackPagable ? DEFAULT_PAGE_REQUEST : fallbackPagable;
    }

    public void setPrefix(String prefix) {
        this.prefix = null == prefix ? DEFAULT_PREFIX : prefix;
    }

    public void setSeparator(String separator) {
        this.separator = null == separator ? DEFAULT_SEPARATOR : separator;
    }

    public Object resolveArgument(MethodParameter methodParameter, NativeWebRequest webRequest) {
        if (methodParameter.getParameterType().equals(Pageable.class)) {
            this.assertPageableUniqueness(methodParameter);
            Pageable request = this.getDefaultFromAnnotationOrFallback(methodParameter);
            ServletRequest servletRequest = (ServletRequest)webRequest.getNativeRequest();
            ServletRequestParameterPropertyValues propertyValues = new ServletRequestParameterPropertyValues(servletRequest, this.getPrefix(methodParameter), this.separator);
            ServletRequestDataBinder binder = new ServletRequestDataBinder((Object)request);
            binder.initDirectFieldAccess();
            binder.registerCustomEditor(Sort.class, (PropertyEditor)new SortPropertyEditor("sort.dir", (PropertyValues)propertyValues));
            binder.bind((PropertyValues)propertyValues);
            if (request.getPageNumber() > 0) {
                request = new PageRequest(request.getPageNumber() - 1, request.getPageSize(), request.getSort());
            }
            return request;
        }
        return UNRESOLVED;
    }

    private Pageable getDefaultFromAnnotationOrFallback(MethodParameter methodParameter) {
        for (Annotation annotation : methodParameter.getParameterAnnotations()) {
            if (!(annotation instanceof PageableDefaults)) continue;
            return PageableArgumentResolver.getDefaultPageRequestFrom((PageableDefaults)annotation);
        }
        return new PageRequest(this.fallbackPagable.getPageNumber(), this.fallbackPagable.getPageSize(), this.fallbackPagable.getSort());
    }

    private static Pageable getDefaultPageRequestFrom(PageableDefaults defaults) {
        int defaultPageNumber = defaults.pageNumber() + 1;
        int defaultPageSize = defaults.value();
        if (defaults.sort().length == 0) {
            return new PageRequest(defaultPageNumber, defaultPageSize);
        }
        return new PageRequest(defaultPageNumber, defaultPageSize, defaults.sortDir(), defaults.sort());
    }

    private String getPrefix(MethodParameter parameter) {
        for (Annotation annotation : parameter.getParameterAnnotations()) {
            if (!(annotation instanceof Qualifier)) continue;
            return ((Qualifier)annotation).value() + "_" + this.prefix;
        }
        return this.prefix;
    }

    private void assertPageableUniqueness(MethodParameter parameter) {
        Method method = parameter.getMethod();
        if (this.containsMoreThanOnePageableParameter(method)) {
            Annotation[][] annotations = method.getParameterAnnotations();
            this.assertQualifiersFor(method.getParameterTypes(), annotations);
        }
    }

    private boolean containsMoreThanOnePageableParameter(Method method) {
        boolean pageableFound = false;
        for (Class<?> type : method.getParameterTypes()) {
            if (pageableFound && type.equals(Pageable.class)) {
                return true;
            }
            if (!type.equals(Pageable.class)) continue;
            pageableFound = true;
        }
        return false;
    }

    private void assertQualifiersFor(Class<?>[] parameterTypes, Annotation[][] annotations) {
        HashSet<String> values = new HashSet<String>();
        for (int i = 0; i < annotations.length; ++i) {
            if (!Pageable.class.equals(parameterTypes[i])) continue;
            Qualifier qualifier = this.findAnnotation(annotations[i]);
            if (null == qualifier) {
                throw new IllegalStateException("Ambiguous Pageable arguments in handler method. If you use multiple parameters of type Pageable you need to qualify them with @Qualifier");
            }
            if (values.contains(qualifier.value())) {
                throw new IllegalStateException("Values of the user Qualifiers must be unique!");
            }
            values.add(qualifier.value());
        }
    }

    private Qualifier findAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Qualifier)) continue;
            return (Qualifier)annotation;
        }
        return null;
    }

    private static class SortPropertyEditor
    extends PropertyEditorSupport {
        private final String orderProperty;
        private final PropertyValues values;

        public SortPropertyEditor(String orderProperty, PropertyValues values) {
            this.orderProperty = orderProperty;
            this.values = values;
        }

        public void setAsText(String text) {
            PropertyValue rawOrder = this.values.getPropertyValue(this.orderProperty);
            Sort.Direction order = null == rawOrder ? Sort.Direction.ASC : Sort.Direction.fromString(rawOrder.getValue().toString());
            this.setValue(new Sort(order, text));
        }
    }
}

