/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.mvc;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpClientRequest;
import org.springframework.cloud.sleuth.http.HttpClientResponse;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.client.HttpStatusCodeException;

public final class TracingClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Log log = LogFactory.getLog(TracingClientHttpRequestInterceptor.class);
    final CurrentTraceContext currentTraceContext;
    final HttpClientHandler handler;

    public static ClientHttpRequestInterceptor create(CurrentTraceContext currentTraceContext, HttpClientHandler httpClientHandler) {
        return new TracingClientHttpRequestInterceptor(currentTraceContext, httpClientHandler);
    }

    @Autowired
    TracingClientHttpRequestInterceptor(CurrentTraceContext currentTraceContext, HttpClientHandler httpClientHandler) {
        this.currentTraceContext = currentTraceContext;
        this.handler = httpClientHandler;
    }

    /*
     * Loose catch block
     */
    public ClientHttpResponse intercept(HttpRequest req, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse clientHttpResponse;
        CurrentTraceContext.Scope ws;
        Throwable error;
        ClientHttpResponse response;
        Span span;
        HttpRequestWrapper request;
        block11: {
            request = new HttpRequestWrapper(req);
            span = this.handler.handleSend((HttpClientRequest)request);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wrapping an outbound http call with span [" + span + "]"));
            }
            response = null;
            error = null;
            ws = this.currentTraceContext.newScope(span.context());
            clientHttpResponse = response = execution.execute(req, body);
            if (ws == null) break block11;
            ws.close();
        }
        this.handler.handleReceive((HttpClientResponse)new ClientHttpResponseWrapper(request, response, error), span);
        return clientHttpResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        error = e;
                        throw e;
                    }
                }
                catch (Throwable throwable3) {
                    this.handler.handleReceive((HttpClientResponse)new ClientHttpResponseWrapper(request, response, error), span);
                    throw throwable3;
                }
            }
        }
    }

    static final class ClientHttpResponseWrapper
    implements HttpClientResponse {
        final HttpRequestWrapper request;
        @Nullable
        final ClientHttpResponse response;
        @Nullable
        final Throwable error;

        ClientHttpResponseWrapper(HttpRequestWrapper request, @Nullable ClientHttpResponse response, @Nullable Throwable error) {
            this.request = request;
            this.response = response;
            this.error = error;
        }

        public Object unwrap() {
            return this.response;
        }

        public Collection<String> headerNames() {
            return this.response != null ? this.response.getHeaders().keySet() : Collections.emptyList();
        }

        public HttpRequestWrapper request() {
            return this.request;
        }

        public Throwable error() {
            return this.error;
        }

        public int statusCode() {
            try {
                int result;
                int n = result = this.response != null ? this.response.getRawStatusCode() : 0;
                if (result <= 0 && this.error instanceof HttpStatusCodeException) {
                    result = ((HttpStatusCodeException)this.error).getRawStatusCode();
                }
                return result;
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    static final class HttpRequestWrapper
    implements HttpClientRequest {
        final HttpRequest delegate;

        HttpRequestWrapper(HttpRequest delegate) {
            this.delegate = delegate;
        }

        public Collection<String> headerNames() {
            return this.delegate.getHeaders().keySet();
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.getMethod().name();
        }

        public String path() {
            return this.delegate.getURI().getPath();
        }

        public String url() {
            return this.delegate.getURI().toString();
        }

        public String header(String name) {
            String result = this.delegate.getHeaders().getFirst(name);
            return result != null ? result.toString() : null;
        }

        public void header(String name, String value) {
            this.delegate.getHeaders().set(name, value);
        }
    }
}

