/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.instrument.reactor.TraceContextPropagator;
import org.springframework.util.Assert;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.util.annotation.Nullable;

final class ReactorHooksHelper {
    static final String LIFTER_NAME = "org.springframework.cloud.sleuth.instrument.reactor.ReactorHooksHelper.ScopePassingLifter";
    static final Class<?> sourceProducerClass;

    private ReactorHooksHelper() {
    }

    public static boolean shouldDecorate(Publisher<?> p) {
        Assert.notNull(p, (String)"source Publisher is null");
        Publisher<?> current = p;
        while (current != null) {
            if (current instanceof Fuseable.ScalarCallable) {
                return false;
            }
            if (ReactorHooksHelper.isTraceContextPropagator(current)) {
                return false;
            }
            if (!ReactorHooksHelper.isSync(current)) {
                boolean isLifter;
                boolean bl = isLifter = ReactorHooksHelper.getLifterName(current) != null;
                if (isLifter) {
                    return ReactorHooksHelper.shouldDecorateLifter(current);
                }
                return true;
            }
            if (ReactorHooksHelper.isSourceProducer(current)) {
                return false;
            }
            current = ReactorHooksHelper.getParent(current);
        }
        return true;
    }

    private static boolean shouldDecorateLifter(Publisher<?> p) {
        Publisher<?> current = ReactorHooksHelper.getParent(p);
        while (current != null) {
            String lifterName = ReactorHooksHelper.getLifterName(current);
            if (ReactorHooksHelper.isScopePassingLifter(lifterName)) {
                return false;
            }
            if (lifterName == null) {
                return true;
            }
            current = ReactorHooksHelper.getParent(current);
        }
        return true;
    }

    private static boolean isScopePassingLifter(String lifterName) {
        return lifterName == LIFTER_NAME;
    }

    private static String getLifterName(Publisher<?> current) {
        return (String)Scannable.from(current).scan(Scannable.Attr.LIFTER);
    }

    public static boolean isTraceContextPropagator(Publisher<?> current) {
        return current instanceof TraceContextPropagator || ReactorHooksHelper.isScopePassingLifter(ReactorHooksHelper.getLifterName(current));
    }

    private static boolean isSourceProducer(Publisher<?> p) {
        return sourceProducerClass.isInstance(p);
    }

    private static boolean isSync(Publisher<?> p) {
        return !(p instanceof Processor) && Scannable.Attr.RunStyle.SYNC == Scannable.from(p).scan(Scannable.Attr.RUN_STYLE);
    }

    @Nullable
    private static Publisher<?> getParent(Publisher<?> publisher) {
        Object parent = Scannable.from(publisher).scanUnsafe(Scannable.Attr.PARENT);
        if (parent instanceof Publisher) {
            return (Publisher)parent;
        }
        return null;
    }

    static <T, U, R> BiFunction<T, U, R> named(String name, BiFunction<T, U, R> delegate) {
        return new NamedLifter<T, U, R>(name, delegate);
    }

    static {
        Class<Object> c;
        try {
            c = Class.forName("reactor.core.publisher.SourceProducer");
        }
        catch (ClassNotFoundException e) {
            c = Void.class;
        }
        sourceProducerClass = c;
    }

    static class NamedLifter<T, U, R>
    implements BiFunction<T, U, R> {
        private final BiFunction<T, U, R> delegate;
        private final String name;

        NamedLifter(String name, BiFunction<T, U, R> delegate) {
            this.name = Objects.requireNonNull(name, "name");
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        public R apply(T t, U u) {
            return this.delegate.apply(t, u);
        }

        public String toString() {
            return this.name;
        }
    }
}

