/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.propagation.TraceContext;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.sleuth.brave.bridge.BraveFinishedSpan;
import org.springframework.cloud.sleuth.exporter.SpanFilter;
import org.springframework.cloud.sleuth.exporter.SpanReporter;

public class CompositeSpanHandler
extends SpanHandler {
    private final List<SpanFilter> filters;
    private final List<SpanReporter> reporters;

    public CompositeSpanHandler(List<SpanFilter> filters, List<SpanReporter> reporters) {
        this.filters = filters == null ? Collections.emptyList() : filters;
        this.reporters = reporters == null ? Collections.emptyList() : reporters;
    }

    public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
        if (cause != SpanHandler.Cause.FINISHED) {
            return true;
        }
        boolean shouldProcess = this.shouldProcess(span);
        if (!shouldProcess) {
            return false;
        }
        shouldProcess = super.end(context, span, cause);
        if (!shouldProcess) {
            return false;
        }
        this.reporters.forEach(r -> r.report(BraveFinishedSpan.fromBrave(span)));
        return true;
    }

    private boolean shouldProcess(MutableSpan span) {
        for (SpanFilter exporter : this.filters) {
            if (exporter.isExportable(BraveFinishedSpan.fromBrave(span))) continue;
            return false;
        }
        return true;
    }
}

