/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.tx;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.tx.TracePlatformTransactionManagerBeanPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.tx.TraceReactiveTransactionManagerBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.tx.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class TraceTxAutoConfiguration {
    @Bean
    @ConditionalOnClass(name={"org.springframework.transaction.PlatformTransactionManager"})
    static TracePlatformTransactionManagerBeanPostProcessor tracePlatformTransactionManagerBeanPostProcessor(BeanFactory beanFactory) {
        return new TracePlatformTransactionManagerBeanPostProcessor(beanFactory);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.transaction.ReactiveTransactionManager", "reactor.core.publisher.Mono"})
    static TraceReactiveTransactionManagerBeanPostProcessor traceReactiveTransactionManagerBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceReactiveTransactionManagerBeanPostProcessor(beanFactory);
    }
}

