/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.r2dbc;

import io.r2dbc.proxy.ProxyConnectionFactory;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.r2dbc.spi.ConnectionFactory;
import java.util.function.Function;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.sleuth.instrument.r2dbc.TraceProxyExecutionListener;

class TraceProxyConnectionFactoryWrapper
implements Function<ConnectionFactory, ConnectionFactory> {
    private final BeanFactory beanFactory;
    private ObjectProvider<ProxyConfig> proxyConfig;

    TraceProxyConnectionFactoryWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public ConnectionFactory apply(ConnectionFactory connectionFactory) {
        ProxyConnectionFactory.Builder builder = ProxyConnectionFactory.builder((ConnectionFactory)connectionFactory);
        this.proxyConfig().ifAvailable(arg_0 -> ((ProxyConnectionFactory.Builder)builder).proxyConfig(arg_0));
        builder.listener((ProxyExecutionListener)new TraceProxyExecutionListener(this.beanFactory, connectionFactory));
        return builder.build();
    }

    private ObjectProvider<ProxyConfig> proxyConfig() {
        if (this.proxyConfig == null) {
            this.proxyConfig = this.beanFactory.getBeanProvider(ProxyConfig.class);
        }
        return this.proxyConfig;
    }
}

