/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.messaging;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.messaging.SleuthMessagingProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.messaging.TraceSpringIntegrationAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.messaging.DefaultMessageSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.messaging.MessageSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.messaging.TracingChannelInterceptor;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.DelegatingWebSocketMessageBrokerConfiguration;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={DelegatingWebSocketMessageBrokerConfiguration.class})
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnProperty(value={"spring.sleuth.integration.websockets.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
class TraceWebSocketAutoConfiguration
extends AbstractWebSocketMessageBrokerConfigurer {
    private final Tracer tracer;
    private final Propagator propagator;
    private final Propagator.Setter<MessageHeaderAccessor> setter;
    private final Propagator.Getter<MessageHeaderAccessor> getter;
    private final SleuthMessagingProperties sleuthMessagingProperties;
    private final MessageSpanCustomizer messageSpanCustomizer;
    private final ApplicationContext applicationContext;

    TraceWebSocketAutoConfiguration(Tracer tracer, Propagator propagator, Propagator.Setter<MessageHeaderAccessor> setter, Propagator.Getter<MessageHeaderAccessor> getter, SleuthMessagingProperties sleuthMessagingProperties, MessageSpanCustomizer messageSpanCustomizer, ApplicationContext applicationContext) {
        this.tracer = tracer;
        this.propagator = propagator;
        this.setter = setter;
        this.getter = getter;
        this.sleuthMessagingProperties = sleuthMessagingProperties;
        this.messageSpanCustomizer = messageSpanCustomizer;
        this.applicationContext = applicationContext;
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.configureBrokerChannel().interceptors(new ChannelInterceptor[]{this.tracingChannelInterceptor()});
    }

    private TracingChannelInterceptor tracingChannelInterceptor() {
        TracingChannelInterceptor tracingChannelInterceptor = new TracingChannelInterceptor(this.tracer, this.propagator, this.setter, this.getter, TraceSpringIntegrationAutoConfiguration.remoteServiceNameMapper(this.sleuthMessagingProperties), this.messageSpanCustomizer);
        tracingChannelInterceptor.setApplicationContext(this.applicationContext);
        return tracingChannelInterceptor;
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.interceptors(new ChannelInterceptor[]{this.tracingChannelInterceptor()});
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.interceptors(new ChannelInterceptor[]{this.tracingChannelInterceptor()});
    }

    @Configuration(proxyBeanMethods=false)
    static class Config {
        Config() {
        }

        @Bean
        @ConditionalOnMissingBean
        MessageSpanCustomizer defaultMessageSpanCustomizer() {
            return new DefaultMessageSpanCustomizer();
        }
    }
}

