/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.config;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.server.config.ConfigServerConfiguration;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.config.TraceEnvironmentRepositoryAspect;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={Tracer.class, ConfigServerProperties.class})
@ConditionalOnClass(value={ConfigServerConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.config.server.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class TraceSpringCloudConfigAutoConfiguration {
    @Bean
    TraceEnvironmentRepositoryAspect traceEnvironmentRepositoryAspect(Tracer tracer) {
        return new TraceEnvironmentRepositoryAspect(tracer);
    }
}

