/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.common.graph;

import java.util.Map;
import shaded.com.google.common.annotations.Beta;
import shaded.com.google.common.base.Function;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.collect.Maps;
import shaded.com.google.common.graph.DirectedMultiNetworkConnections;
import shaded.com.google.common.graph.DirectedNetworkConnections;
import shaded.com.google.common.graph.ElementTypesAreNonnullByDefault;
import shaded.com.google.common.graph.EndpointPair;
import shaded.com.google.common.graph.ImmutableGraph;
import shaded.com.google.common.graph.MutableNetwork;
import shaded.com.google.common.graph.Network;
import shaded.com.google.common.graph.NetworkBuilder;
import shaded.com.google.common.graph.NetworkConnections;
import shaded.com.google.common.graph.StandardNetwork;
import shaded.com.google.common.graph.UndirectedMultiNetworkConnections;
import shaded.com.google.common.graph.UndirectedNetworkConnections;
import shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shaded.com.google.errorprone.annotations.Immutable;

@Immutable(containerOf={"N", "E"})
@ElementTypesAreNonnullByDefault
@Beta
public final class ImmutableNetwork<N, E>
extends StandardNetwork<N, E> {
    private ImmutableNetwork(Network<N, E> network) {
        super(NetworkBuilder.from(network), ImmutableNetwork.getNodeConnections(network), ImmutableNetwork.getEdgeToReferenceNode(network));
    }

    public static <N, E> ImmutableNetwork<N, E> copyOf(Network<N, E> network) {
        return network instanceof ImmutableNetwork ? (ImmutableNetwork<N, E>)network : new ImmutableNetwork<N, E>(network);
    }

    @Deprecated
    public static <N, E> ImmutableNetwork<N, E> copyOf(ImmutableNetwork<N, E> network) {
        return Preconditions.checkNotNull(network);
    }

    @Override
    public ImmutableGraph<N> asGraph() {
        return new ImmutableGraph(super.asGraph());
    }

    private static <N, E> Map<N, NetworkConnections<N, E>> getNodeConnections(Network<N, E> network) {
        ImmutableMap.Builder<N, NetworkConnections<N, E>> nodeConnections = ImmutableMap.builder();
        for (N node : network.nodes()) {
            nodeConnections.put(node, ImmutableNetwork.connectionsOf(network, node));
        }
        return nodeConnections.buildOrThrow();
    }

    private static <N, E> Map<E, N> getEdgeToReferenceNode(Network<N, E> network) {
        ImmutableMap.Builder<E, N> edgeToReferenceNode = ImmutableMap.builder();
        for (E edge : network.edges()) {
            edgeToReferenceNode.put(edge, network.incidentNodes(edge).nodeU());
        }
        return edgeToReferenceNode.buildOrThrow();
    }

    private static <N, E> NetworkConnections<N, E> connectionsOf(Network<N, E> network, N node) {
        if (network.isDirected()) {
            Map<E, N> inEdgeMap = Maps.asMap(network.inEdges(node), ImmutableNetwork.sourceNodeFn(network));
            Map<E, N> outEdgeMap = Maps.asMap(network.outEdges(node), ImmutableNetwork.targetNodeFn(network));
            int selfLoopCount = network.edgesConnecting(node, node).size();
            return network.allowsParallelEdges() ? DirectedMultiNetworkConnections.ofImmutable(inEdgeMap, outEdgeMap, selfLoopCount) : DirectedNetworkConnections.ofImmutable(inEdgeMap, outEdgeMap, selfLoopCount);
        }
        Map<E, N> incidentEdgeMap = Maps.asMap(network.incidentEdges(node), ImmutableNetwork.adjacentNodeFn(network, node));
        return network.allowsParallelEdges() ? UndirectedMultiNetworkConnections.ofImmutable(incidentEdgeMap) : UndirectedNetworkConnections.ofImmutable(incidentEdgeMap);
    }

    private static <N, E> Function<E, N> sourceNodeFn(Network<N, E> network) {
        return edge -> network.incidentNodes(edge).source();
    }

    private static <N, E> Function<E, N> targetNodeFn(Network<N, E> network) {
        return edge -> network.incidentNodes(edge).target();
    }

    private static <N, E> Function<E, N> adjacentNodeFn(Network<N, E> network, N node) {
        return edge -> network.incidentNodes(edge).adjacentNode(node);
    }

    public static class Builder<N, E> {
        private final MutableNetwork<N, E> mutableNetwork;

        Builder(NetworkBuilder<N, E> networkBuilder) {
            this.mutableNetwork = networkBuilder.build();
        }

        @CanIgnoreReturnValue
        public Builder<N, E> addNode(N node) {
            this.mutableNetwork.addNode(node);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N, E> addEdge(N nodeU, N nodeV, E edge) {
            this.mutableNetwork.addEdge(nodeU, nodeV, edge);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N, E> addEdge(EndpointPair<N> endpoints, E edge) {
            this.mutableNetwork.addEdge(endpoints, edge);
            return this;
        }

        public ImmutableNetwork<N, E> build() {
            return ImmutableNetwork.copyOf(this.mutableNetwork);
        }
    }
}

