/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.io;

import java.util.Base64;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

class Base64ProtocolResolver
implements ProtocolResolver {
    private static final String BASE64_PREFIX = "base64:";

    Base64ProtocolResolver() {
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (location.startsWith(BASE64_PREFIX)) {
            String value = location.substring(BASE64_PREFIX.length());
            return new ByteArrayResource(Base64ProtocolResolver.decode(value));
        }
        return null;
    }

    private static byte[] decode(String location) {
        return Base64.getDecoder().decode(location);
    }
}

