/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.encoder.EncoderBase;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.boot.logging.logback.ElasticCommonSchemaStructuredLogFormatter;
import org.springframework.boot.logging.logback.GraylogExtendedLogFormatStructuredLogFormatter;
import org.springframework.boot.logging.logback.LogstashStructuredLogFormatter;
import org.springframework.boot.logging.structured.CommonStructuredLogFormat;
import org.springframework.boot.logging.structured.StructuredLogFormatter;
import org.springframework.boot.logging.structured.StructuredLogFormatterFactory;
import org.springframework.boot.logging.structured.StructuredLoggingJsonMembersCustomizer;
import org.springframework.boot.util.Instantiator;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class StructuredLogEncoder
extends EncoderBase<ILoggingEvent> {
    private final ThrowableProxyConverter throwableProxyConverter = new ThrowableProxyConverter();
    private String format;
    private StructuredLogFormatter<ILoggingEvent> formatter;
    private Charset charset = StandardCharsets.UTF_8;

    public void setFormat(String format) {
        this.format = format;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void start() {
        Assert.state((this.format != null ? 1 : 0) != 0, (String)"Format has not been set");
        this.formatter = this.createFormatter(this.format);
        super.start();
        this.throwableProxyConverter.start();
    }

    private StructuredLogFormatter<ILoggingEvent> createFormatter(String format) {
        Environment environment = (Environment)this.getContext().getObject(Environment.class.getName());
        Assert.state((environment != null ? 1 : 0) != 0, (String)"Unable to find Spring Environment in logger context");
        return new StructuredLogFormatterFactory<ILoggingEvent>(ILoggingEvent.class, environment, this::addAvailableParameters, this::addCommonFormatters).get(format);
    }

    private void addAvailableParameters(Instantiator.AvailableParameters availableParameters) {
        availableParameters.add(ThrowableProxyConverter.class, this.throwableProxyConverter);
    }

    private void addCommonFormatters(StructuredLogFormatterFactory.CommonFormatters<ILoggingEvent> commonFormatters) {
        commonFormatters.add(CommonStructuredLogFormat.ELASTIC_COMMON_SCHEMA, this::createEcsFormatter);
        commonFormatters.add(CommonStructuredLogFormat.GRAYLOG_EXTENDED_LOG_FORMAT, this::createGraylogFormatter);
        commonFormatters.add(CommonStructuredLogFormat.LOGSTASH, this::createLogstashFormatter);
    }

    private StructuredLogFormatter<ILoggingEvent> createEcsFormatter(Instantiator<?> instantiator) {
        Environment environment = instantiator.getArg(Environment.class);
        ThrowableProxyConverter throwableProxyConverter = instantiator.getArg(ThrowableProxyConverter.class);
        StructuredLoggingJsonMembersCustomizer jsonMembersCustomizer = instantiator.getArg(StructuredLoggingJsonMembersCustomizer.class);
        return new ElasticCommonSchemaStructuredLogFormatter(environment, throwableProxyConverter, jsonMembersCustomizer);
    }

    private StructuredLogFormatter<ILoggingEvent> createGraylogFormatter(Instantiator<?> instantiator) {
        Environment environment = instantiator.getArg(Environment.class);
        ThrowableProxyConverter throwableProxyConverter = instantiator.getArg(ThrowableProxyConverter.class);
        StructuredLoggingJsonMembersCustomizer jsonMembersCustomizer = instantiator.getArg(StructuredLoggingJsonMembersCustomizer.class);
        return new GraylogExtendedLogFormatStructuredLogFormatter(environment, throwableProxyConverter, jsonMembersCustomizer);
    }

    private StructuredLogFormatter<ILoggingEvent> createLogstashFormatter(Instantiator<?> instantiator) {
        ThrowableProxyConverter throwableProxyConverter = instantiator.getArg(ThrowableProxyConverter.class);
        StructuredLoggingJsonMembersCustomizer jsonMembersCustomizer = instantiator.getArg(StructuredLoggingJsonMembersCustomizer.class);
        return new LogstashStructuredLogFormatter(throwableProxyConverter, jsonMembersCustomizer);
    }

    public void stop() {
        this.throwableProxyConverter.stop();
        super.stop();
    }

    public byte[] headerBytes() {
        return null;
    }

    public byte[] encode(ILoggingEvent event) {
        return this.formatter.formatAsBytes(event, this.charset != null ? this.charset : StandardCharsets.UTF_8);
    }

    public byte[] footerBytes() {
        return null;
    }
}

