/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.springframework.boot.maven.AbstractAotMojo;
import org.springframework.boot.maven.AbstractDependencyFilterMojo;
import org.springframework.boot.maven.RunArguments;
import org.springframework.boot.maven.SpringBootApplicationClassFinder;
import org.springframework.util.ObjectUtils;

@Mojo(name="process-aot", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ProcessAotMojo
extends AbstractAotMojo {
    private static final String AOT_PROCESSOR_CLASS_NAME = "org.springframework.boot.SpringApplicationAotProcessor";
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.directory}/spring-aot/main/sources", required=true)
    private File generatedSources;
    @Parameter(defaultValue="${project.build.directory}/spring-aot/main/resources", required=true)
    private File generatedResources;
    @Parameter(defaultValue="${project.build.directory}/spring-aot/main/classes", required=true)
    private File generatedClasses;
    @Parameter(property="spring-boot.aot.main-class")
    private String mainClass;
    @Parameter
    private String[] arguments;
    @Parameter
    private String[] profiles;

    @Override
    protected void executeAot() throws Exception {
        String applicationClass = this.mainClass != null ? this.mainClass : SpringBootApplicationClassFinder.findSingleClass(this.classesDirectory);
        URL[] classPath = this.getClassPath();
        this.generateAotAssets(classPath, AOT_PROCESSOR_CLASS_NAME, this.getAotArguments(applicationClass));
        this.compileSourceFiles(classPath, this.generatedSources, this.classesDirectory);
        this.copyAll(this.generatedResources.toPath(), this.classesDirectory.toPath());
        this.copyAll(this.generatedClasses.toPath(), this.classesDirectory.toPath());
    }

    private String[] getAotArguments(String applicationClass) {
        ArrayList<String> aotArguments = new ArrayList<String>();
        aotArguments.add(applicationClass);
        aotArguments.add(this.generatedSources.toString());
        aotArguments.add(this.generatedResources.toString());
        aotArguments.add(this.generatedClasses.toString());
        aotArguments.add(this.project.getGroupId());
        aotArguments.add(this.project.getArtifactId());
        aotArguments.addAll(this.resolveArguments().getArgs());
        return (String[])aotArguments.toArray(String[]::new);
    }

    private URL[] getClassPath() throws Exception {
        File[] directories = new File[]{this.classesDirectory, this.generatedClasses};
        return this.getClassPath(directories, new ArtifactsFilter[]{new AbstractDependencyFilterMojo.ExcludeTestScopeArtifactFilter(), DEVTOOLS_EXCLUDE_FILTER, DOCKER_COMPOSE_EXCLUDE_FILTER});
    }

    private RunArguments resolveArguments() {
        RunArguments runArguments = new RunArguments(this.arguments);
        if (!ObjectUtils.isEmpty((Object[])this.profiles)) {
            runArguments.getArgs().addFirst("--spring.profiles.active=" + String.join((CharSequence)",", this.profiles));
        }
        return runArguments;
    }
}

