/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.reactive;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.WebFilterChainProxy;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import reactor.core.publisher.Flux;

@AutoConfiguration
@EnableConfigurationProperties(value={SecurityProperties.class})
@ConditionalOnClass(value={Flux.class, EnableWebFluxSecurity.class, WebFilterChainProxy.class, WebFluxConfigurer.class})
public class ReactiveSecurityAutoConfiguration {

    static final class EnableWebFluxSecurityCondition
    extends AnyNestedCondition {
        EnableWebFluxSecurityCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={SecurityWebFilterChain.class})
        static final class ConditionalOnSecurityWebFilterChain {
            ConditionalOnSecurityWebFilterChain() {
            }
        }

        @ConditionalOnBean(value={ReactiveUserDetailsService.class})
        static final class ConditionalOnReactiveUserDetailsService {
            ConditionalOnReactiveUserDetailsService() {
            }
        }

        @ConditionalOnBean(value={ReactiveAuthenticationManager.class})
        static final class ConditionalOnReactiveAuthenticationManagerBean {
            ConditionalOnReactiveAuthenticationManagerBean() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={WebFilterChainProxy.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Conditional(value={EnableWebFluxSecurityCondition.class})
    @EnableWebFluxSecurity
    static class EnableWebFluxSecurityConfiguration {
        EnableWebFluxSecurityConfiguration() {
        }
    }
}

