/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.ConnectionString;
import org.springframework.boot.autoconfigure.mongo.MongoConnectionDetails;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;

public class PropertiesMongoConnectionDetails
implements MongoConnectionDetails {
    private final MongoProperties properties;

    public PropertiesMongoConnectionDetails(MongoProperties properties) {
        this.properties = properties;
    }

    @Override
    public ConnectionString getConnectionString() {
        if (this.properties.getUri() != null) {
            return new ConnectionString(this.properties.getUri());
        }
        StringBuilder builder = new StringBuilder("mongodb://");
        if (this.properties.getUsername() != null) {
            builder.append(this.properties.getUsername());
            builder.append(":");
            builder.append(this.properties.getPassword());
            builder.append("@");
        }
        builder.append(this.properties.getHost() != null ? this.properties.getHost() : "localhost");
        if (this.properties.getPort() != null) {
            builder.append(":");
            builder.append(this.properties.getPort());
        }
        if (this.properties.getAdditionalHosts() != null) {
            builder.append(String.join((CharSequence)",", this.properties.getAdditionalHosts()));
        }
        if (this.properties.getMongoClientDatabase() != null || this.properties.getReplicaSetName() != null || this.properties.getAuthenticationDatabase() != null) {
            builder.append("/");
            if (this.properties.getMongoClientDatabase() != null) {
                builder.append(this.properties.getMongoClientDatabase());
            } else if (this.properties.getAuthenticationDatabase() != null) {
                builder.append(this.properties.getAuthenticationDatabase());
            }
            if (this.properties.getReplicaSetName() != null) {
                builder.append("?");
                builder.append("replicaSet=");
                builder.append(this.properties.getReplicaSetName());
            }
        }
        return new ConnectionString(builder.toString());
    }

    @Override
    public MongoConnectionDetails.GridFs getGridFs() {
        return MongoConnectionDetails.GridFs.of(this.properties.getGridfs().getDatabase(), this.properties.getGridfs().getBucket());
    }
}

