/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Arrays;
import junit.framework.TestCase;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class MessageFormatterTest
extends TestCase {
    Integer i1 = new Integer(1);
    Integer i2 = new Integer(2);
    Integer i3 = new Integer(3);
    Integer[] ia0 = new Integer[]{this.i1, this.i2, this.i3};
    Integer[] ia1 = new Integer[]{new Integer(10), new Integer(20), new Integer(30)};
    String result;

    public void testNull() {
        this.result = MessageFormatter.format(null, (Object)this.i1).getMessage();
        MessageFormatterTest.assertEquals(null, (String)this.result);
    }

    public void testNullParam() {
        this.result = MessageFormatter.format((String)"Value is {}.", null).getMessage();
        MessageFormatterTest.assertEquals((String)"Value is null.", (String)this.result);
        this.result = MessageFormatter.format((String)"Val1 is {}, val2 is {}.", null, null).getMessage();
        MessageFormatterTest.assertEquals((String)"Val1 is null, val2 is null.", (String)this.result);
        this.result = MessageFormatter.format((String)"Val1 is {}, val2 is {}.", (Object)this.i1, null).getMessage();
        MessageFormatterTest.assertEquals((String)"Val1 is 1, val2 is null.", (String)this.result);
        this.result = MessageFormatter.format((String)"Val1 is {}, val2 is {}.", null, (Object)this.i2).getMessage();
        MessageFormatterTest.assertEquals((String)"Val1 is null, val2 is 2.", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Val1 is {}, val2 is {}, val3 is {}", (Object[])new Integer[]{null, null, null}).getMessage();
        MessageFormatterTest.assertEquals((String)"Val1 is null, val2 is null, val3 is null", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Val1 is {}, val2 is {}, val3 is {}", (Object[])new Integer[]{null, this.i2, this.i3}).getMessage();
        MessageFormatterTest.assertEquals((String)"Val1 is null, val2 is 2, val3 is 3", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Val1 is {}, val2 is {}, val3 is {}", (Object[])new Integer[]{null, null, this.i3}).getMessage();
        MessageFormatterTest.assertEquals((String)"Val1 is null, val2 is null, val3 is 3", (String)this.result);
    }

    public void testOneParameter() {
        this.result = MessageFormatter.format((String)"Value is {}.", (Object)this.i3).getMessage();
        MessageFormatterTest.assertEquals((String)"Value is 3.", (String)this.result);
        this.result = MessageFormatter.format((String)"Value is {", (Object)this.i3).getMessage();
        MessageFormatterTest.assertEquals((String)"Value is {", (String)this.result);
        this.result = MessageFormatter.format((String)"{} is larger than 2.", (Object)this.i3).getMessage();
        MessageFormatterTest.assertEquals((String)"3 is larger than 2.", (String)this.result);
        this.result = MessageFormatter.format((String)"No subst", (Object)this.i3).getMessage();
        MessageFormatterTest.assertEquals((String)"No subst", (String)this.result);
        this.result = MessageFormatter.format((String)"Incorrect {subst", (Object)this.i3).getMessage();
        MessageFormatterTest.assertEquals((String)"Incorrect {subst", (String)this.result);
        this.result = MessageFormatter.format((String)"Value is {bla} {}", (Object)this.i3).getMessage();
        MessageFormatterTest.assertEquals((String)"Value is {bla} 3", (String)this.result);
        this.result = MessageFormatter.format((String)"Escaped \\{} subst", (Object)this.i3).getMessage();
        MessageFormatterTest.assertEquals((String)"Escaped {} subst", (String)this.result);
        this.result = MessageFormatter.format((String)"{Escaped", (Object)this.i3).getMessage();
        MessageFormatterTest.assertEquals((String)"{Escaped", (String)this.result);
        this.result = MessageFormatter.format((String)"\\{}Escaped", (Object)this.i3).getMessage();
        MessageFormatterTest.assertEquals((String)"{}Escaped", (String)this.result);
        this.result = MessageFormatter.format((String)"File name is {{}}.", (Object)"App folder.zip").getMessage();
        MessageFormatterTest.assertEquals((String)"File name is {App folder.zip}.", (String)this.result);
        this.result = MessageFormatter.format((String)"File name is C:\\\\{}.", (Object)"App folder.zip").getMessage();
        MessageFormatterTest.assertEquals((String)"File name is C:\\App folder.zip.", (String)this.result);
    }

    public void testTwoParameters() {
        this.result = MessageFormatter.format((String)"Value {} is smaller than {}.", (Object)this.i1, (Object)this.i2).getMessage();
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2.", (String)this.result);
        this.result = MessageFormatter.format((String)"Value {} is smaller than {}", (Object)this.i1, (Object)this.i2).getMessage();
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2", (String)this.result);
        this.result = MessageFormatter.format((String)"{}{}", (Object)this.i1, (Object)this.i2).getMessage();
        MessageFormatterTest.assertEquals((String)"12", (String)this.result);
        this.result = MessageFormatter.format((String)"Val1={}, Val2={", (Object)this.i1, (Object)this.i2).getMessage();
        MessageFormatterTest.assertEquals((String)"Val1=1, Val2={", (String)this.result);
        this.result = MessageFormatter.format((String)"Value {} is smaller than \\{}", (Object)this.i1, (Object)this.i2).getMessage();
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than {}", (String)this.result);
        this.result = MessageFormatter.format((String)"Value {} is smaller than \\{} tail", (Object)this.i1, (Object)this.i2).getMessage();
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than {} tail", (String)this.result);
        this.result = MessageFormatter.format((String)"Value {} is smaller than \\{", (Object)this.i1, (Object)this.i2).getMessage();
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than \\{", (String)this.result);
        this.result = MessageFormatter.format((String)"Value {} is smaller than {tail", (Object)this.i1, (Object)this.i2).getMessage();
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than {tail", (String)this.result);
        this.result = MessageFormatter.format((String)"Value \\{} is smaller than {}", (Object)this.i1, (Object)this.i2).getMessage();
        MessageFormatterTest.assertEquals((String)"Value {} is smaller than 1", (String)this.result);
    }

    public void testExceptionIn_toString() {
        Object o = new Object(){

            public String toString() {
                throw new IllegalStateException("a");
            }
        };
        this.result = MessageFormatter.format((String)"Troublesome object {}", (Object)o).getMessage();
        MessageFormatterTest.assertEquals((String)"Troublesome object [FAILED toString()]", (String)this.result);
    }

    public void testNullArray() {
        String msg0 = "msg0";
        String msg1 = "msg1 {}";
        String msg2 = "msg2 {} {}";
        String msg3 = "msg3 {} {} {}";
        Object[] args = null;
        this.result = MessageFormatter.arrayFormat((String)msg0, args).getMessage();
        MessageFormatterTest.assertEquals((String)msg0, (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)msg1, args).getMessage();
        MessageFormatterTest.assertEquals((String)msg1, (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)msg2, args).getMessage();
        MessageFormatterTest.assertEquals((String)msg2, (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)msg3, args).getMessage();
        MessageFormatterTest.assertEquals((String)msg3, (String)this.result);
    }

    public void testArrayFormat() {
        this.result = MessageFormatter.arrayFormat((String)"Value {} is smaller than {} and {}.", (Object[])this.ia0).getMessage();
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2 and 3.", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"{}{}{}", (Object[])this.ia0).getMessage();
        MessageFormatterTest.assertEquals((String)"123", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}.", (Object[])this.ia0).getMessage();
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2.", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}", (Object[])this.ia0).getMessage();
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Val={}, {, Val={}", (Object[])this.ia0).getMessage();
        MessageFormatterTest.assertEquals((String)"Val=1, {, Val=2", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Val={}, {, Val={}", (Object[])this.ia0).getMessage();
        MessageFormatterTest.assertEquals((String)"Val=1, {, Val=2", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Val1={}, Val2={", (Object[])this.ia0).getMessage();
        MessageFormatterTest.assertEquals((String)"Val1=1, Val2={", (String)this.result);
    }

    public void testArrayValues() {
        Integer p0 = this.i1;
        Integer[] p1 = new Integer[]{this.i2, this.i3};
        this.result = MessageFormatter.format((String)"{}{}", (Object)p0, (Object)p1).getMessage();
        MessageFormatterTest.assertEquals((String)"1[2, 3]", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", p1}).getMessage();
        MessageFormatterTest.assertEquals((String)"a[2, 3]", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new byte[]{1, 2}}).getMessage();
        MessageFormatterTest.assertEquals((String)"a[1, 2]", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new int[]{1, 2}}).getMessage();
        MessageFormatterTest.assertEquals((String)"a[1, 2]", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new float[]{1.0f, 2.0f}}).getMessage();
        MessageFormatterTest.assertEquals((String)"a[1.0, 2.0]", (String)this.result);
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new double[]{1.0, 2.0}}).getMessage();
        MessageFormatterTest.assertEquals((String)"a[1.0, 2.0]", (String)this.result);
    }

    public void testMultiDimensionalArrayValues() {
        Integer[][] multiIntegerA = new Integer[][]{this.ia0, this.ia1};
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiIntegerA}).getMessage();
        MessageFormatterTest.assertEquals((String)"a[[1, 2, 3], [10, 20, 30]]", (String)this.result);
        int[][] multiIntA = new int[][]{{1, 2}, {10, 20}};
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiIntA}).getMessage();
        MessageFormatterTest.assertEquals((String)"a[[1, 2], [10, 20]]", (String)this.result);
        float[][] multiFloatA = new float[][]{{1.0f, 2.0f}, {10.0f, 20.0f}};
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiFloatA}).getMessage();
        MessageFormatterTest.assertEquals((String)"a[[1.0, 2.0], [10.0, 20.0]]", (String)this.result);
        Object[][] multiOA = new Object[][]{this.ia0, this.ia1};
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiOA}).getMessage();
        MessageFormatterTest.assertEquals((String)"a[[1, 2, 3], [10, 20, 30]]", (String)this.result);
        Object[][][] _3DOA = new Object[][][]{multiOA, multiOA};
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", _3DOA}).getMessage();
        MessageFormatterTest.assertEquals((String)"a[[[1, 2, 3], [10, 20, 30]], [[1, 2, 3], [10, 20, 30]]]", (String)this.result);
    }

    public void testCyclicArrays() {
        Object[] b;
        Object[] cyclicA;
        cyclicA[0] = cyclicA = new Object[1];
        MessageFormatterTest.assertEquals((String)"[[...]]", (String)MessageFormatter.arrayFormat((String)"{}", (Object[])cyclicA).getMessage());
        Object[] a = new Object[2];
        a[0] = this.i1;
        Object[] c = new Object[]{this.i3, a};
        a[1] = b = new Object[]{this.i2, c};
        MessageFormatterTest.assertEquals((String)"1[2, [3, [1, [...]]]]", (String)MessageFormatter.arrayFormat((String)"{}{}", (Object[])a).getMessage());
    }

    public void testArrayThrowable() {
        Throwable t = new Throwable();
        Object[] ia = new Object[]{this.i1, this.i2, this.i3, t};
        Object[] iaWitness = new Object[]{this.i1, this.i2, this.i3};
        FormattingTuple ft = MessageFormatter.arrayFormat((String)"Value {} is smaller than {} and {}.", (Object[])ia);
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2 and 3.", (String)ft.getMessage());
        MessageFormatterTest.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        MessageFormatterTest.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"{}{}{}", (Object[])ia);
        MessageFormatterTest.assertEquals((String)"123", (String)ft.getMessage());
        MessageFormatterTest.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        MessageFormatterTest.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}.", (Object[])ia);
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2.", (String)ft.getMessage());
        MessageFormatterTest.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        MessageFormatterTest.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}", (Object[])ia);
        MessageFormatterTest.assertEquals((String)"Value 1 is smaller than 2", (String)ft.getMessage());
        MessageFormatterTest.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        MessageFormatterTest.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Val={}, {, Val={}", (Object[])ia);
        MessageFormatterTest.assertEquals((String)"Val=1, {, Val=2", (String)ft.getMessage());
        MessageFormatterTest.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        MessageFormatterTest.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Val={}, \\{, Val={}", (Object[])ia);
        MessageFormatterTest.assertEquals((String)"Val=1, \\{, Val=2", (String)ft.getMessage());
        MessageFormatterTest.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        MessageFormatterTest.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Val1={}, Val2={", (Object[])ia);
        MessageFormatterTest.assertEquals((String)"Val1=1, Val2={", (String)ft.getMessage());
        MessageFormatterTest.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        MessageFormatterTest.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Value {} is smaller than {} and {} -- {} .", (Object[])ia);
        MessageFormatterTest.assertEquals((String)("Value 1 is smaller than 2 and 3 -- " + t.toString() + " ."), (String)ft.getMessage());
        MessageFormatterTest.assertTrue((boolean)Arrays.equals(ia, ft.getArgArray()));
        MessageFormatterTest.assertNull((Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"{}{}{}{}", (Object[])ia);
        MessageFormatterTest.assertEquals((String)("123" + t.toString()), (String)ft.getMessage());
        MessageFormatterTest.assertTrue((boolean)Arrays.equals(ia, ft.getArgArray()));
        MessageFormatterTest.assertNull((Object)ft.getThrowable());
    }
}

