/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import jakarta.mail.Authenticator;
import jakarta.mail.Session;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.MailException;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.internal.authenticatedsockssupport.socks5server.AnonymousSocks5Server;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.config.EmailGovernance;
import org.simplejavamail.api.mailer.config.OperationalConfig;
import org.simplejavamail.api.mailer.config.ProxyConfig;
import org.simplejavamail.api.mailer.config.ServerConfig;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.internal.moduleloader.ModuleLoader;
import org.simplejavamail.internal.util.ListUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.internal.util.concurrent.AsyncOperationHelper;
import org.simplejavamail.mailer.MailerHelper;
import org.simplejavamail.mailer.internal.MailerException;
import org.simplejavamail.mailer.internal.MailerFromSessionBuilderImpl;
import org.simplejavamail.mailer.internal.MailerRegularBuilderImpl;
import org.simplejavamail.mailer.internal.SendMailClosure;
import org.simplejavamail.mailer.internal.SessionBasedEmailToMimeMessageConverter;
import org.simplejavamail.mailer.internal.TestConnectionClosure;
import org.simplejavamail.mailer.internal.util.SmtpAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailerImpl
implements Mailer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailerImpl.class);
    @NotNull
    private final Session session;
    @NotNull
    private final OperationalConfig operationalConfig;
    @Nullable
    private final AnonymousSocks5Server proxyServer;
    @NotNull
    private final AtomicInteger smtpConnectionCounter = new AtomicInteger();
    @NotNull
    private final EmailGovernance emailGovernance;
    @Nullable
    private final TransportStrategy transportStrategy;
    @Nullable
    private final ServerConfig serverConfig;
    @NotNull
    private final ProxyConfig proxyConfig;

    MailerImpl(@NotNull MailerFromSessionBuilderImpl fromSessionBuilder) {
        this(null, null, fromSessionBuilder.buildEmailGovernance(), fromSessionBuilder.buildProxyConfig(), fromSessionBuilder.getSession(), fromSessionBuilder.buildOperationalConfig());
    }

    MailerImpl(@NotNull MailerRegularBuilderImpl regularBuilder) {
        this(regularBuilder.buildServerConfig(), regularBuilder.getTransportStrategy(), regularBuilder.buildEmailGovernance(), regularBuilder.buildProxyConfig(), null, regularBuilder.buildOperationalConfig());
    }

    MailerImpl(@Nullable ServerConfig serverConfig, @Nullable TransportStrategy transportStrategy, @NotNull EmailGovernance emailGovernance, @NotNull ProxyConfig proxyConfig, @Nullable Session session, @NotNull OperationalConfig operationalConfig) {
        this.serverConfig = serverConfig;
        this.transportStrategy = transportStrategy;
        this.emailGovernance = emailGovernance;
        this.proxyConfig = proxyConfig;
        if (session == null) {
            session = MailerImpl.createMailSession(serverConfig, (TransportStrategy)Preconditions.checkNonEmptyArgument((Object)transportStrategy, (String)"transportStrategy"));
        }
        this.session = session;
        this.operationalConfig = operationalConfig;
        TransportStrategy effectiveTransportStrategy = Optional.ofNullable(transportStrategy).orElse(TransportStrategy.findStrategyForSession((Session)session));
        this.proxyServer = MailerImpl.configureSessionWithProxy(proxyConfig, operationalConfig, session, effectiveTransportStrategy);
        MailerImpl.initSession(session, operationalConfig, emailGovernance, effectiveTransportStrategy);
        this.initCluster(session, operationalConfig);
    }

    @NotNull
    public static Session createMailSession(@Nullable ServerConfig serverConfig, @NotNull TransportStrategy transportStrategy) {
        Properties props = transportStrategy.generateProperties();
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.EXTRA_PROPERTIES)) {
            props.putAll((Map<?, ?>)((Map)ConfigLoader.getProperty((ConfigLoader.Property)ConfigLoader.Property.EXTRA_PROPERTIES)));
        }
        if (serverConfig != null) {
            props.put(transportStrategy.propertyNameHost(), serverConfig.getHost());
            props.put(transportStrategy.propertyNamePort(), String.valueOf(serverConfig.getPort()));
            if (serverConfig.getUsername() != null) {
                props.put(transportStrategy.propertyNameUsername(), serverConfig.getUsername());
            }
            if (serverConfig.getCustomSSLFactoryInstance() != null) {
                props.put("mail.smtp.ssl.socketFactory", serverConfig.getCustomSSLFactoryInstance());
            } else if (serverConfig.getCustomSSLFactoryClass() != null) {
                props.put("mail.smtp.ssl.socketFactory.class", serverConfig.getCustomSSLFactoryClass());
            }
            if (transportStrategy == TransportStrategy.SMTP_OAUTH2 && serverConfig.getPassword() == null) {
                throw new MailerException("TransportStrategy is OAUTH2 but no OAUTH2 token provided as password");
            }
            if (serverConfig.getPassword() != null) {
                if (transportStrategy != TransportStrategy.SMTP_OAUTH2) {
                    props.put(transportStrategy.propertyNameAuthenticate(), "true");
                    return Session.getInstance((Properties)props, (Authenticator)new SmtpAuthenticator(serverConfig));
                }
                props.put("simplejavamail.oauth2.token", serverConfig.getPassword());
                return Session.getInstance((Properties)props);
            }
        }
        return Session.getInstance((Properties)props);
    }

    private static void initSession(@NotNull Session session, @NotNull OperationalConfig operationalConfig, @NotNull EmailGovernance emailGovernance, @Nullable TransportStrategy transportStrategy) {
        session.setDebug(operationalConfig.isDebugLogging());
        session.getProperties().putAll((Map<?, ?>)operationalConfig.getProperties());
        MailerImpl.configureSessionWithTimeout(session, operationalConfig.getSessionTimeout(), transportStrategy);
        MailerImpl.configureTrustedHosts(session, operationalConfig, transportStrategy);
        MailerImpl.configureServerIdentityVerification(session, operationalConfig, transportStrategy);
        SessionBasedEmailToMimeMessageConverter.primeSession(session, operationalConfig, emailGovernance);
    }

    private static void configureSessionWithTimeout(@NotNull Session session, int sessionTimeout, @Nullable TransportStrategy transportStrategy) {
        if (transportStrategy != null) {
            Properties sessionProperties = session.getProperties();
            sessionProperties.put(transportStrategy.propertyNameConnectionTimeout(), String.valueOf(sessionTimeout));
            sessionProperties.put(transportStrategy.propertyNameTimeout(), String.valueOf(sessionTimeout));
            sessionProperties.put(transportStrategy.propertyNameWriteTimeout(), String.valueOf(sessionTimeout));
        } else {
            LOGGER.debug("No transport strategy provided, skipping defaults for .connectiontimout, .timout and .writetimeout");
        }
    }

    private static void configureTrustedHosts(@NotNull Session session, @NotNull OperationalConfig operationalConfig, @Nullable TransportStrategy transportStrategy) {
        if (transportStrategy != null) {
            if (operationalConfig.isTrustAllSSLHost()) {
                session.getProperties().setProperty(transportStrategy.propertyNameSSLTrust(), "*");
            } else {
                List hosts = operationalConfig.getSslHostsToTrust();
                String sslPropertyForTrustingHosts = transportStrategy.propertyNameSSLTrust();
                session.getProperties().remove(sslPropertyForTrustingHosts);
                if (!hosts.isEmpty()) {
                    StringBuilder builder = new StringBuilder((String)ListUtil.getFirst((List)hosts));
                    for (int i = 1; i < hosts.size(); ++i) {
                        builder.append(" ").append((String)hosts.get(i));
                    }
                    session.getProperties().setProperty(sslPropertyForTrustingHosts, builder.toString());
                }
            }
        } else {
            LOGGER.debug("No transport strategy provided, skipping configuration for trusted hosts");
        }
    }

    private static void configureServerIdentityVerification(@NotNull Session session, @NotNull OperationalConfig operationalConfig, @Nullable TransportStrategy transportStrategy) {
        if (transportStrategy != null && transportStrategy != TransportStrategy.SMTP) {
            session.getProperties().setProperty(transportStrategy.propertyNameCheckServerIdentity(), Boolean.toString(operationalConfig.isVerifyingServerIdentity()));
        }
    }

    @Nullable
    private static AnonymousSocks5Server configureSessionWithProxy(@NotNull ProxyConfig proxyConfig, @NotNull OperationalConfig operationalConfig, @NotNull Session session, @Nullable TransportStrategy transportStrategy) {
        if (operationalConfig.getCustomMailer() != null) {
            LOGGER.trace("CustomMailer provided by user, skipping proxy.");
        } else if (!proxyConfig.requiresProxy()) {
            LOGGER.trace("No proxy set, skipping proxy.");
        } else {
            if (transportStrategy == TransportStrategy.SMTPS) {
                throw new MailerException("Proxy is not supported for SSL connections (this is a limitation by the underlying JavaMail framework)");
            }
            Properties sessionProperties = session.getProperties();
            if (transportStrategy != null) {
                sessionProperties.put(transportStrategy.propertyNameSocksHost(), Preconditions.verifyNonnullOrEmpty((Object)proxyConfig.getRemoteProxyHost()));
                sessionProperties.put(transportStrategy.propertyNameSocksPort(), String.valueOf(proxyConfig.getRemoteProxyPort()));
            } else {
                LOGGER.debug("no transport strategy provided, expecting mail.smtp(s).socks.host and .port properties to be set to proxy config on Session");
            }
            if (proxyConfig.requiresAuthentication()) {
                if (transportStrategy != null) {
                    sessionProperties.put(transportStrategy.propertyNameSocksHost(), "localhost");
                    sessionProperties.put(transportStrategy.propertyNameSocksPort(), String.valueOf(proxyConfig.getProxyBridgePort()));
                } else {
                    LOGGER.debug("no transport strategy provided but authenticated proxy required, expecting mail.smtp(s).socks.host and .port properties to be set to localhost and port " + proxyConfig.getProxyBridgePort());
                }
                return ModuleLoader.loadAuthenticatedSocksModule().createAnonymousSocks5Server(proxyConfig);
            }
        }
        return null;
    }

    private void initCluster(@NotNull Session session, @NotNull OperationalConfig operationalConfig) {
        if (ModuleLoader.batchModuleAvailable()) {
            ModuleLoader.loadBatchModule().registerToCluster(operationalConfig, operationalConfig.getClusterKey(), session);
        }
    }

    public void testConnection() {
        this.testConnection(false);
    }

    @NotNull
    public synchronized CompletableFuture<Void> testConnection(boolean async) {
        TestConnectionClosure testConnectionClosure = new TestConnectionClosure(this.operationalConfig, this.session, this.proxyServer, async, this.smtpConnectionCounter);
        if (!async) {
            testConnectionClosure.run();
            return CompletableFuture.completedFuture(null);
        }
        return ModuleLoader.loadBatchModule().executeAsync("testSMTPConnection process", (Runnable)testConnectionClosure);
    }

    @NotNull
    public final CompletableFuture<Void> sendMail(Email email) {
        return this.sendMail(email, this.getOperationalConfig().isAsync());
    }

    @NotNull
    public final CompletableFuture<Void> sendMail(Email email, boolean async) {
        if (this.validate(email)) {
            SendMailClosure sendMailClosure = new SendMailClosure(this.operationalConfig, this.session, email, this.proxyServer, this.operationalConfig.isTransportModeLoggingOnly(), this.smtpConnectionCounter);
            if (!async) {
                sendMailClosure.run();
                return CompletableFuture.completedFuture(null);
            }
            return ModuleLoader.batchModuleAvailable() ? ModuleLoader.loadBatchModule().executeAsync(this.operationalConfig.getExecutorService(), "sendMail process", (Runnable)sendMailClosure) : AsyncOperationHelper.executeAsync((ExecutorService)this.operationalConfig.getExecutorService(), (String)"sendMail process", (Runnable)sendMailClosure);
        }
        throw new IllegalStateException("Email not valid, but no MailException was thrown for it");
    }

    public boolean validate(@NotNull Email email) throws MailException {
        return this.operationalConfig.isDisableAllClientValidation() ? MailerHelper.validateLenient(email, this.emailGovernance.getEmailValidator()) : MailerHelper.validate(email, this.emailGovernance.getEmailValidator());
    }

    public Future<?> shutdownConnectionPool() {
        if (!this.operationalConfig.isExecutorServiceIsUserProvided()) {
            this.operationalConfig.getExecutorService().shutdown();
        }
        return ModuleLoader.loadBatchModule().shutdownConnectionPools(this.session);
    }

    public String toString() {
        return "MailerImpl {\n\tserverConfig=" + this.serverConfig + ",\n\ttransportStrategy=" + this.transportStrategy + ",\n\tproxyConfig=" + this.proxyConfig + ",\n\toperationalConfig=" + this.operationalConfig + ",\n\temailGovernance=" + this.emailGovernance + ",\n\tsession=" + this.session.getProperties() + "\n}";
    }

    public Session getSession() {
        LOGGER.warn("Providing access to Session instance for emergency fall-back scenario. Please let us know why you need it.");
        LOGGER.warn("\t\t> https://github.com/bbottema/simple-java-mail/issues");
        return this.session;
    }

    @Nullable
    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Nullable
    public TransportStrategy getTransportStrategy() {
        return this.transportStrategy;
    }

    @NotNull
    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @NotNull
    public OperationalConfig getOperationalConfig() {
        return this.operationalConfig;
    }

    @NotNull
    public EmailGovernance getEmailGovernance() {
        return this.emailGovernance;
    }
}

