/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.mailer.config.EmailGovernance;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProduceException;
import org.simplejavamail.converter.internal.mimemessage.SpecializedMimeMessageProducer;

class MimeMessageProducerRelatedAlternative
extends SpecializedMimeMessageProducer {
    MimeMessageProducerRelatedAlternative() {
    }

    @Override
    boolean compatibleWithEmail(@NotNull Email email) {
        return !MimeMessageProducerRelatedAlternative.emailContainsMixedContent(email) && MimeMessageProducerRelatedAlternative.emailContainsRelatedContent(email) && MimeMessageProducerRelatedAlternative.emailContainsAlternativeContent(email);
    }

    @Override
    public void populateMimeMessageMultipartStructure(MimeMessage message, Email email, EmailGovernance emailGovernance) throws MessagingException {
        MultipartStructureWrapper multipartStructureWrapper = new MultipartStructureWrapper();
        MimeMessageHelper.setTexts(email, emailGovernance, multipartStructureWrapper.multipartAlternativeMessages);
        MimeMessageHelper.setEmbeddedImages(email, emailGovernance, multipartStructureWrapper.multipartRootRelated);
        message.setContent((Multipart)multipartStructureWrapper.multipartRootRelated);
    }

    private static class MultipartStructureWrapper {
        private final MimeMultipart multipartRootRelated = new MimeMultipart("related");
        private final MimeMultipart multipartAlternativeMessages;

        private MultipartStructureWrapper() {
            MimeBodyPart contentRelated = new MimeBodyPart();
            this.multipartAlternativeMessages = new MimeMultipart("alternative");
            MimeBodyPart contentAlternativeMessages = new MimeBodyPart();
            try {
                contentRelated.setContent((Multipart)this.multipartRootRelated);
                this.multipartRootRelated.addBodyPart((BodyPart)contentAlternativeMessages);
                contentAlternativeMessages.setContent((Multipart)this.multipartAlternativeMessages);
            }
            catch (MessagingException e) {
                throw new MimeMessageProduceException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

