/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.map.getter.CharacterContextualGetter;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.primitive.CharacterGetter;

public final class CharacterResultSetGetter
implements CharacterGetter<ResultSet>,
Getter<ResultSet, Character>,
CharacterContextualGetter<ResultSet>,
ContextualGetter<ResultSet, Character> {
    private final int column;

    public CharacterResultSetGetter(int column) {
        this.column = column;
    }

    public char getCharacter(ResultSet target) throws SQLException {
        return (char)target.getInt(this.column);
    }

    public Character get(ResultSet target) throws SQLException {
        char c = this.getCharacter(target);
        if (c == '\u0000' && target.wasNull()) {
            return null;
        }
        return Character.valueOf(c);
    }

    public char getCharacter(ResultSet resultSet, Context mappingContext) throws Exception {
        return this.getCharacter(resultSet);
    }

    public Character get(ResultSet resultSet, Context context) throws Exception {
        return this.get(resultSet);
    }

    public String toString() {
        return "CharacterResultSetGetter{property=" + this.column + "}";
    }
}

