/* *##%
 * Copyright (c) 2009 ruchaud. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty.multistorage;

import java.util.Collection;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyStorage;
import org.sharengo.wikitty.WikittyTransaction;

/**
 *
 * @author ruchaud
 * @version $Revision: 1 $
 *
 * Last update: $Date: 2010-04-16 10:29:38 +0200 (ven., 16 avril 2010) $
 * by : $Author: echatellier $
 */
public class WikittyMultiStorage implements WikittyStorage {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyMultiStorage.class);

    protected MultiStorageConfiguration configuration;

    public WikittyMultiStorage(MultiStorageConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public UpdateResponse store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement) {
        List<WikittyStorage> wikittyStorageMasters = configuration.getWikittyStorageMasters();
        for (WikittyStorage wikittyStorage : wikittyStorageMasters) {
            wikittyStorage.store(transaction, wikitties, disableAutoVersionIncrement);
        }

        List<WikittyStorage> wikittyStorageReplications = configuration.getWikittyStorageReplications();
        for (WikittyStorage wikittyStorage : wikittyStorageReplications) {
            wikittyStorage.store(transaction, wikitties, disableAutoVersionIncrement);
        }

        // nothing to put in result
        UpdateResponse result = new UpdateResponse();
        return result;
    }

    @Override
    public boolean exists(WikittyTransaction transaction, String id) {
        WikittyStorage currentMasterWikittyStorage = configuration.getCurrentMasterWikittyStorage();
        boolean result = currentMasterWikittyStorage.exists(transaction, id);
        return result;
    }

    @Override
    public boolean isDeleted(WikittyTransaction transaction, String id) {
        WikittyStorage currentMasterWikittyStorage = configuration.getCurrentMasterWikittyStorage();
        boolean result = currentMasterWikittyStorage.isDeleted(transaction, id);
        return result;
    }

    @Override
    public Wikitty restore(WikittyTransaction transaction, String id, String... fqFieldName) throws WikittyException {
        WikittyStorage currentMasterWikittyStorage = configuration.getCurrentMasterWikittyStorage();
        Wikitty result = currentMasterWikittyStorage.restore(transaction, id, fqFieldName);
        return result;
    }

    @Override
    public UpdateResponse delete(WikittyTransaction transaction, Collection<String> idList) throws WikittyException {
        List<WikittyStorage> wikittyStorageMasters = configuration.getWikittyStorageMasters();
        for (WikittyStorage wikittyStorage : wikittyStorageMasters) {
            wikittyStorage.delete(transaction, idList);
        }

        List<WikittyStorage> wikittyStorageReplications = configuration.getWikittyStorageReplications();
        for (WikittyStorage wikittyStorage : wikittyStorageReplications) {
            wikittyStorage.delete(transaction, idList);
        }

        // nothing to put in result
        UpdateResponse result = new UpdateResponse();
        return result;
    }

    @Override
    public void scanWikitties(WikittyTransaction transaction, Scanner scanner) {
        WikittyStorage currentMasterWikittyStorage = configuration.getCurrentMasterWikittyStorage();
        currentMasterWikittyStorage.scanWikitties(transaction, scanner);
    }

    @Override
    public void clear(WikittyTransaction transaction) {
        List<WikittyStorage> wikittyStorageMasters = configuration.getWikittyStorageMasters();
        for (WikittyStorage wikittyStorage : wikittyStorageMasters) {
            wikittyStorage.clear(transaction);
        }

        List<WikittyStorage> wikittyStorageReplications = configuration.getWikittyStorageReplications();
        for (WikittyStorage wikittyStorage : wikittyStorageReplications) {
            wikittyStorage.clear(transaction);
        }
    }
    
}
