/* *##%
 * Copyright (c) 2009 ruchaud. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty.jpa;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.AbstractWikittyService;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittySearchEngin;
import org.sharengo.wikitty.WikittyStorage;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author ruchaud
 * @version $Revision: 1 $
 *
 * Last update: $Date: 2010-04-16 10:29:38 +0200 (ven., 16 avril 2010) $
 * by : $Author: echatellier $
 */
public class WikittyServiceJPA extends AbstractWikittyService {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyServiceJPA.class);

    @Autowired
    protected WikittySearchEngin searchEngin;

    @Autowired
    protected WikittyExtensionStorage extensionStorage;

    @Autowired
    protected WikittyStorage wikittyStorage;

    public WikittyServiceJPA() {
    }

    @Override
    protected WikittySearchEngin getSearchEngin() {
        return searchEngin;
    }

    @Override
    protected WikittyExtensionStorage getExtensionStorage() {
        return extensionStorage;
    }

    @Override
    protected WikittyStorage getWikittyStorage() {
        return wikittyStorage;
    }
}
