package org.sharengo.wikitty.search;

// Start of user code for import

import java.io.Serializable;

// End of user code  for import

/**
 * <!-- Start of user code for RestrictionDto -->
 * 
 * <p>
 * This element is a symbolic interface implemented by all operators used to
 * request contents (And, Or, Not, Equals, NotEquals, EndsWith, ...).
 * </p>
 * 
 * <!-- End of user code for RestrictionDto -->
 */
public class Restriction implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    protected RestrictionName name;

    /**
     * Default constructor
     */
    public Restriction() {
        super();
    }

    /**
     * Constructor with all parameters initialized
     * 
     * @param name
     */
    public Restriction(RestrictionName name) {
        this.name = name;
    }

    /**
     * Return name
     * 
     * @return
     */
    public RestrictionName getName() {
        return name;
    }

    /**
     * Set a value to parameter name.
     * 
     * @param name
     */
    public void setName(RestrictionName name) {
        this.name = name;
    }

    /**
     * Equality test based attributes values
     * 
     * @param value
     *            Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Restriction)) {
            return false;
        }

        final Restriction restrictionDto = (Restriction) other;

        if ((name == null && restrictionDto.getName() != null)
                || (name != null && !name.equals(restrictionDto.getName())))
            return false;

        return true;
    }

    public int hashCode() {
        int result = Restriction.class.getName().hashCode();
        if (name != null) {
            result = 29 * result + name.hashCode();
        }
        return result;
    }

}