package org.sharengo.wikitty.search;

// Start of user code for import

import java.io.Serializable;

// End of user code  for import

/**
 * <!-- Start of user code for Greater -->
 * 
 * <p>
 * Greater operator is used to build restriction containing "element &gt; value"
 * where element could be a Integer, a Float or a Date. <br>
 * <br>
 * For example, use: RestrictionHelper.less( myElement ,
 * RestrictionHelper.DATE_FORMAT.format(new Date()) )
 * </p>
 * 
 * <!-- End of user code for Greater -->
 */
public class Greater extends BinaryOperator implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    /**
     * Default constructor
     */
    public Greater() {
        super();
    }

    /**
     * Equality test based attributes values
     * 
     * @param value
     *            Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Greater)) {
            return false;
        }

        final Greater greater = (Greater) other;

        return super.equals(greater);
    }

    public int hashCode() {
        int result = Greater.class.getName().hashCode();
        result = 29 * result + super.hashCode();
        return result;
    }

}