/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class CdpEndpointFinder {
    private static final Logger LOG = Logger.getLogger(CdpEndpointFinder.class.getName());
    private static final Json JSON = new Json();

    @Deprecated
    public static HttpClient getHttpClient(HttpClient.Factory clientFactory, URI reportedUri) {
        return CdpEndpointFinder.getHttpClient(clientFactory, reportedUri, ClientConfig.defaultConfig());
    }

    public static HttpClient getHttpClient(HttpClient.Factory clientFactory, URI reportedUri, ClientConfig clientConfig) {
        Require.nonNull((String)"HTTP client factory", (Object)clientFactory);
        Require.nonNull((String)"DevTools URI", (Object)reportedUri);
        ClientConfig config = clientConfig.baseUri(reportedUri);
        return clientFactory.createClient(config);
    }

    public static Optional<URI> getCdpEndPoint(HttpClient client) {
        HttpResponse res;
        Require.nonNull((String)"HTTP client", (Object)client);
        try {
            res = client.execute(new HttpRequest(HttpMethod.GET, "/json/version"));
        }
        catch (UncheckedIOException e) {
            LOG.warning("Unable to connect to determine websocket url: " + e.getMessage());
            return Optional.empty();
        }
        if (res.getStatus() != 200) {
            return Optional.empty();
        }
        Map versionData = (Map)JSON.toType(res.contentAsString(), Json.MAP_TYPE);
        Object raw = versionData.get("webSocketDebuggerUrl");
        if (!(raw instanceof String)) {
            return Optional.empty();
        }
        String debuggerUrl = (String)raw;
        try {
            return Optional.of(new URI(debuggerUrl));
        }
        catch (URISyntaxException e) {
            LOG.warning("Invalid URI for endpoint " + String.valueOf(raw));
            return Optional.empty();
        }
    }

    public static Optional<URI> getReportedUri(Capabilities caps) {
        String key;
        switch (caps.getBrowserName()) {
            case "chrome": {
                key = "goog:chromeOptions";
                break;
            }
            case "msedge": {
                key = "ms:edgeOptions";
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        return CdpEndpointFinder.getReportedUri(key, caps);
    }

    public static Optional<URI> getReportedUri(String capabilityKey, Capabilities caps) {
        Object raw = caps.getCapability(capabilityKey);
        if (raw instanceof Map) {
            raw = ((Map)raw).get("debuggerAddress");
        }
        if (!(raw instanceof String)) {
            LOG.fine("No debugger address");
            return Optional.empty();
        }
        int index = ((String)raw).lastIndexOf(58);
        if (index == -1 || index == ((String)raw).length() - 1) {
            LOG.fine("No index in " + String.valueOf(raw));
            return Optional.empty();
        }
        try {
            URI uri = new URI(String.format("http://%s", raw));
            LOG.fine("URI found: " + String.valueOf(uri));
            return Optional.of(uri);
        }
        catch (URISyntaxException e) {
            LOG.warning("Unable to create URI from: " + String.valueOf(raw));
            return Optional.empty();
        }
    }
}

