/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v128.webaudio.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v128.webaudio.model.ContextRealtimeData;
import org.openqa.selenium.devtools.v128.webaudio.model.ContextState;
import org.openqa.selenium.devtools.v128.webaudio.model.ContextType;
import org.openqa.selenium.devtools.v128.webaudio.model.GraphObjectId;
import org.openqa.selenium.json.JsonInput;

public class BaseAudioContext {
    private final GraphObjectId contextId;
    private final ContextType contextType;
    private final ContextState contextState;
    private final Optional<ContextRealtimeData> realtimeData;
    private final Number callbackBufferSize;
    private final Number maxOutputChannelCount;
    private final Number sampleRate;

    public BaseAudioContext(GraphObjectId contextId, ContextType contextType, ContextState contextState, Optional<ContextRealtimeData> realtimeData, Number callbackBufferSize, Number maxOutputChannelCount, Number sampleRate) {
        this.contextId = Objects.requireNonNull(contextId, "contextId is required");
        this.contextType = Objects.requireNonNull(contextType, "contextType is required");
        this.contextState = Objects.requireNonNull(contextState, "contextState is required");
        this.realtimeData = realtimeData;
        this.callbackBufferSize = Objects.requireNonNull(callbackBufferSize, "callbackBufferSize is required");
        this.maxOutputChannelCount = Objects.requireNonNull(maxOutputChannelCount, "maxOutputChannelCount is required");
        this.sampleRate = Objects.requireNonNull(sampleRate, "sampleRate is required");
    }

    public GraphObjectId getContextId() {
        return this.contextId;
    }

    public ContextType getContextType() {
        return this.contextType;
    }

    public ContextState getContextState() {
        return this.contextState;
    }

    public Optional<ContextRealtimeData> getRealtimeData() {
        return this.realtimeData;
    }

    public Number getCallbackBufferSize() {
        return this.callbackBufferSize;
    }

    public Number getMaxOutputChannelCount() {
        return this.maxOutputChannelCount;
    }

    public Number getSampleRate() {
        return this.sampleRate;
    }

    private static BaseAudioContext fromJson(JsonInput input) {
        GraphObjectId contextId = null;
        ContextType contextType = null;
        ContextState contextState = null;
        Optional<ContextRealtimeData> realtimeData = Optional.empty();
        Number callbackBufferSize = 0;
        Number maxOutputChannelCount = 0;
        Number sampleRate = 0;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "contextId": {
                    contextId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block18;
                }
                case "contextType": {
                    contextType = (ContextType)((Object)input.read(ContextType.class));
                    continue block18;
                }
                case "contextState": {
                    contextState = (ContextState)((Object)input.read(ContextState.class));
                    continue block18;
                }
                case "realtimeData": {
                    realtimeData = Optional.ofNullable((ContextRealtimeData)input.read(ContextRealtimeData.class));
                    continue block18;
                }
                case "callbackBufferSize": {
                    callbackBufferSize = input.nextNumber();
                    continue block18;
                }
                case "maxOutputChannelCount": {
                    maxOutputChannelCount = input.nextNumber();
                    continue block18;
                }
                case "sampleRate": {
                    sampleRate = input.nextNumber();
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BaseAudioContext(contextId, contextType, contextState, realtimeData, callbackBufferSize, maxOutputChannelCount, sampleRate);
    }
}

