/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;

public class Proxy {
    private static final String PROXY_TYPE = "proxyType";
    private static final String FTP_PROXY = "ftpProxy";
    private static final String HTTP_PROXY = "httpProxy";
    private static final String NO_PROXY = "noProxy";
    private static final String SSL_PROXY = "sslProxy";
    private static final String SOCKS_PROXY = "socksProxy";
    private static final String SOCKS_VERSION = "socksVersion";
    private static final String SOCKS_USERNAME = "socksUsername";
    private static final String SOCKS_PASSWORD = "socksPassword";
    private static final String PROXY_AUTOCONFIG_URL = "proxyAutoconfigUrl";
    private static final String AUTODETECT = "autodetect";
    private ProxyType proxyType = ProxyType.UNSPECIFIED;
    private boolean autodetect = false;
    private String ftpProxy;
    private String httpProxy;
    private String noProxy;
    private String sslProxy;
    private String socksProxy;
    private Integer socksVersion;
    private String socksUsername;
    private String socksPassword;
    private String proxyAutoconfigUrl;

    public Proxy() {
    }

    public Proxy(Map<String, ?> raw) {
        HashMap<String, Consumer<Object>> setters = new HashMap<String, Consumer<Object>>();
        setters.put(PROXY_TYPE, value -> this.setProxyType(ProxyType.valueOf(((String)value).toUpperCase())));
        setters.put(FTP_PROXY, value -> this.setFtpProxy((String)value));
        setters.put(HTTP_PROXY, value -> this.setHttpProxy((String)value));
        setters.put(NO_PROXY, rawData -> {
            if (rawData instanceof List) {
                this.setNoProxy(((List)rawData).stream().map(Object::toString).collect(Collectors.joining(", ")));
            } else {
                this.setNoProxy((String)rawData);
            }
        });
        setters.put(SSL_PROXY, value -> this.setSslProxy((String)value));
        setters.put(SOCKS_PROXY, value -> this.setSocksProxy((String)value));
        setters.put(SOCKS_VERSION, value -> this.setSocksVersion(((Number)value).intValue()));
        setters.put(SOCKS_USERNAME, value -> this.setSocksUsername((String)value));
        setters.put(SOCKS_PASSWORD, value -> this.setSocksPassword((String)value));
        setters.put(PROXY_AUTOCONFIG_URL, value -> this.setProxyAutoconfigUrl((String)value));
        setters.put(AUTODETECT, value -> this.setAutodetect((Boolean)value));
        raw.forEach((key, value) -> {
            if (key != null && value != null) {
                ((Consumer)setters.get(key)).accept(value);
            }
        });
    }

    public Map<String, Object> toJson() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (this.proxyType != ProxyType.UNSPECIFIED) {
            m.put(PROXY_TYPE, this.proxyType.toString());
        }
        if (this.ftpProxy != null) {
            m.put(FTP_PROXY, this.ftpProxy);
        }
        if (this.httpProxy != null) {
            m.put(HTTP_PROXY, this.httpProxy);
        }
        if (this.noProxy != null) {
            m.put(NO_PROXY, Arrays.asList(this.noProxy.split(",\\s*")));
        }
        if (this.sslProxy != null) {
            m.put(SSL_PROXY, this.sslProxy);
        }
        if (this.socksProxy != null) {
            m.put(SOCKS_PROXY, this.socksProxy);
        }
        if (this.socksVersion != null) {
            m.put(SOCKS_VERSION, this.socksVersion);
        }
        if (this.socksUsername != null) {
            m.put(SOCKS_USERNAME, this.socksUsername);
        }
        if (this.socksPassword != null) {
            m.put(SOCKS_PASSWORD, this.socksPassword);
        }
        if (this.proxyAutoconfigUrl != null) {
            m.put(PROXY_AUTOCONFIG_URL, this.proxyAutoconfigUrl);
        }
        if (this.autodetect) {
            m.put(AUTODETECT, true);
        }
        return m;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public Proxy setProxyType(ProxyType proxyType) {
        this.verifyProxyTypeCompatibility(proxyType);
        this.proxyType = proxyType;
        return this;
    }

    public boolean isAutodetect() {
        return this.autodetect;
    }

    public Proxy setAutodetect(boolean autodetect) {
        if (this.autodetect == autodetect) {
            return this;
        }
        if (autodetect) {
            this.verifyProxyTypeCompatibility(ProxyType.AUTODETECT);
            this.proxyType = ProxyType.AUTODETECT;
        } else {
            this.proxyType = ProxyType.UNSPECIFIED;
        }
        this.autodetect = autodetect;
        return this;
    }

    public String getFtpProxy() {
        return this.ftpProxy;
    }

    public Proxy setFtpProxy(String ftpProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.ftpProxy = ftpProxy;
        return this;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public Proxy setHttpProxy(String httpProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.httpProxy = httpProxy;
        return this;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public Proxy setNoProxy(String noProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.noProxy = noProxy;
        return this;
    }

    public String getSslProxy() {
        return this.sslProxy;
    }

    public Proxy setSslProxy(String sslProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.sslProxy = sslProxy;
        return this;
    }

    public String getSocksProxy() {
        return this.socksProxy;
    }

    public Proxy setSocksProxy(String socksProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.socksProxy = socksProxy;
        return this;
    }

    public Integer getSocksVersion() {
        return this.socksVersion;
    }

    public Proxy setSocksVersion(Integer socksVersion) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.socksVersion = socksVersion;
        return this;
    }

    public String getSocksUsername() {
        return this.socksUsername;
    }

    public Proxy setSocksUsername(String username) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.socksUsername = username;
        return this;
    }

    public String getSocksPassword() {
        return this.socksPassword;
    }

    public Proxy setSocksPassword(String password) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.socksPassword = password;
        return this;
    }

    public String getProxyAutoconfigUrl() {
        return this.proxyAutoconfigUrl;
    }

    public Proxy setProxyAutoconfigUrl(String proxyAutoconfigUrl) {
        this.verifyProxyTypeCompatibility(ProxyType.PAC);
        this.proxyType = ProxyType.PAC;
        this.proxyAutoconfigUrl = proxyAutoconfigUrl;
        return this;
    }

    private void verifyProxyTypeCompatibility(ProxyType compatibleProxy) {
        if (this.proxyType != ProxyType.UNSPECIFIED && this.proxyType != compatibleProxy) {
            throw new IllegalStateException(String.format("Specified proxy type (%s) not compatible with current setting (%s)", new Object[]{compatibleProxy, this.proxyType}));
        }
    }

    public static Proxy extractFrom(Capabilities capabilities) {
        Object rawProxy = capabilities.getCapability("proxy");
        Proxy proxy = null;
        if (rawProxy != null) {
            if (rawProxy instanceof Proxy) {
                proxy = (Proxy)rawProxy;
            } else if (rawProxy instanceof Map) {
                proxy = new Proxy((Map)rawProxy);
            }
        }
        return proxy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Proxy(");
        switch (this.getProxyType().ordinal()) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                builder.append(this.getProxyType().toString().toLowerCase());
                break;
            }
            case 2: {
                builder.append("pac: ").append(this.getProxyAutoconfigUrl());
                break;
            }
        }
        Optional.ofNullable(this.getFtpProxy()).ifPresent(p -> builder.append(", ftp=").append((String)p));
        Optional.ofNullable(this.getHttpProxy()).ifPresent(p -> builder.append(", http=").append((String)p));
        Optional.ofNullable(this.getSocksProxy()).ifPresent(p -> builder.append(", socks=").append((String)p));
        Optional.ofNullable(this.getSslProxy()).ifPresent(p -> builder.append(", ssl=").append((String)p));
        builder.append(")");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Proxy proxy = (Proxy)o;
        return this.isAutodetect() == proxy.isAutodetect() && this.getProxyType() == proxy.getProxyType() && Objects.equals(this.getFtpProxy(), proxy.getFtpProxy()) && Objects.equals(this.getHttpProxy(), proxy.getHttpProxy()) && Objects.equals(this.getNoProxy(), proxy.getNoProxy()) && Objects.equals(this.getSslProxy(), proxy.getSslProxy()) && Objects.equals(this.getSocksProxy(), proxy.getSocksProxy()) && Objects.equals(this.getSocksVersion(), proxy.getSocksVersion()) && Objects.equals(this.getSocksUsername(), proxy.getSocksUsername()) && Objects.equals(this.getSocksPassword(), proxy.getSocksPassword()) && Objects.equals(this.getProxyAutoconfigUrl(), proxy.getProxyAutoconfigUrl());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getProxyType(), this.isAutodetect(), this.getFtpProxy(), this.getHttpProxy(), this.getNoProxy(), this.getSslProxy(), this.getSocksProxy(), this.getSocksVersion(), this.getSocksUsername(), this.getSocksPassword(), this.getProxyAutoconfigUrl()});
    }

    public static enum ProxyType {
        DIRECT("direct"),
        MANUAL("manual"),
        PAC("pac"),
        RESERVED_1("reserved_1"),
        AUTODETECT("autodetect"),
        SYSTEM("system"),
        UNSPECIFIED("unspecified");

        private final String type;

        private ProxyType(String type) {
            this.type = type;
        }

        public String toString() {
            return String.valueOf(this.type);
        }
    }
}

