/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.robotframework.mavenplugin.Arguments;
import org.robotframework.mavenplugin.LibDocMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibDocConfiguration {
    private File outputDirectory;
    private File outputFile;
    private String name;
    private String version;
    private String libraryOrResourceFile;
    private File[] extraPathDirectories;
    private File defaultExtraPath;

    public String[] generateRunArguments() {
        Arguments generatedArguments = new Arguments();
        generatedArguments.add("libdoc");
        generatedArguments.addNonEmptyStringToArguments(this.name, "--name");
        generatedArguments.addNonEmptyStringToArguments(this.version, "--version");
        generatedArguments.addFileListToArguments(this.getExtraPathDirectoriesWithDefault(), "--pythonpath");
        generatedArguments.add(this.getLibraryOrResource());
        generatedArguments.add(this.getOutputPath());
        return generatedArguments.toArray();
    }

    private String getLibraryOrResource() {
        File libOrResource = new File(this.libraryOrResourceFile);
        if (libOrResource.exists()) {
            return libOrResource.getAbsolutePath();
        }
        return this.libraryOrResourceFile;
    }

    private String getOutputPath() {
        return this.outputDirectory + File.separator + this.outputFile.getName();
    }

    private List<File> getExtraPathDirectoriesWithDefault() {
        if (this.extraPathDirectories == null) {
            return Collections.singletonList(this.defaultExtraPath);
        }
        return Arrays.asList(this.extraPathDirectories);
    }

    public void ensureOutputDirectoryExists() throws IOException {
        if (this.outputDirectory == null) {
            String baseDir = System.getProperty("basedir");
            if (baseDir == null) {
                baseDir = ".";
            }
            this.outputDirectory = new File(this.joinPaths(baseDir, "target", "robotframework", "libdoc"));
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new IOException("Target output directory cannot be created: " + this.outputDirectory.getAbsolutePath());
        }
    }

    private String joinPaths(String ... parts) {
        return StringUtils.join((Object[])parts, (String)File.separator);
    }

    public void populateDefaults(LibDocMojo defaults) {
        if (this.outputDirectory == null) {
            this.outputDirectory = defaults.defaultLibdocOutputDirectory;
        }
        this.defaultExtraPath = defaults.libdocDefaultExtraPath;
    }
}

