/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UpdateModelException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.validator.Validator;
import org.richfaces.component.AbstractDivPanel;
import org.richfaces.component.AbstractTogglePanelItem;
import org.richfaces.component.Method;
import org.richfaces.event.SelectedItemChangeEvent;
import org.richfaces.event.SelectedItemChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTogglePanel
extends AbstractDivPanel
implements EditableValueHolder {
    public static final String COMPONENT_TYPE = "org.richfaces.panels.TogglePanel";
    public static final String COMPONENT_FAMILY = "org.richfaces.panels.TogglePanel";
    private String submittedSelectedItem = null;

    protected AbstractTogglePanel() {
        this.setRendererType("org.richfaces.panels.TogglePanelRenderer");
    }

    public Object getSubmittedValue() {
        return this.submittedSelectedItem;
    }

    public void resetValue() {
        this.setValue(null);
        this.setSubmittedValue(null);
        this.setLocalValueSet(false);
        this.setValid(true);
    }

    public void setSubmittedValue(Object submittedValue) {
        this.submittedSelectedItem = String.valueOf(submittedValue);
    }

    public boolean isLocalValueSet() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.localValueSet), (Object)false);
    }

    public void setLocalValueSet(boolean localValueSet) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.localValueSet), (Object)localValueSet);
    }

    public boolean isValid() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.valid), (Object)true);
    }

    public void setValid(boolean valid) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.valid), (Object)valid);
    }

    public boolean isRequired() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.required), (Object)false);
    }

    public void setRequired(boolean required) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.required), (Object)required);
    }

    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), (Object)false);
    }

    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), (Object)immediate);
    }

    public MethodBinding getValidator() {
        throw new UnknownError();
    }

    public void setValidator(MethodBinding validatorBinding) {
        throw new UnknownError();
    }

    public MethodBinding getValueChangeListener() {
        throw new UnsupportedOperationException();
    }

    public void setValueChangeListener(MethodBinding valueChangeMethod) {
        throw new UnsupportedOperationException();
    }

    public void addValidator(Validator validator) {
        throw new UnsupportedOperationException();
    }

    public Validator[] getValidators() {
        throw new UnsupportedOperationException();
    }

    public void removeValidator(Validator validator) {
        throw new UnsupportedOperationException();
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public ValueChangeListener[] getValueChangeListeners() {
        throw new UnsupportedOperationException();
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!this.isSelectedItem(kid)) continue;
            kid.processDecodes(context);
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        finally {
            this.popComponentFromEL(context);
        }
        this.executeValidate(context);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Application app = context.getApplication();
        app.publishEvent(context, PreValidateEvent.class, (Object)this);
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!this.isSelectedItem(kid)) continue;
            kid.processValidators(context);
        }
        app.publishEvent(context, PostValidateEvent.class, (Object)this);
        this.popComponentFromEL(context);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!this.isSelectedItem(kid)) continue;
            kid.processUpdates(context);
        }
        this.popComponentFromEL(context);
        try {
            this.updateModel(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setValid(true);
        super.decode(context);
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression ve = this.getValueExpression("value");
        if (ve == null) {
            return;
        }
        Throwable caught = null;
        FacesMessage message = null;
        try {
            ve.setValue(context.getELContext(), this.getLocalValue());
            this.setValue(null);
            this.setLocalValueSet(false);
        }
        catch (ELException e) {
            caught = e;
            String messageStr = e.getMessage();
            for (Throwable result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                messageStr = result.getMessage();
            }
            if (messageStr == null) {
                // empty if block
            }
            this.setValid(false);
        }
        catch (Exception e) {
            caught = e;
            this.setValid(false);
        }
        if (caught != null) {
            assert (message != null);
            UpdateModelException toQueue = new UpdateModelException(message, caught);
            ExceptionQueuedEventContext eventContext = new ExceptionQueuedEventContext(context, (Throwable)toQueue, (UIComponent)this, PhaseId.UPDATE_MODEL_VALUES);
            context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, (Object)eventContext);
        }
    }

    private void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.validationFailed();
            context.renderResponse();
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String submittedValue = this.getSubmittedSelectedItem();
        if (submittedValue == null) {
            return;
        }
        String previous = (String)this.getValue();
        this.setValue(submittedValue);
        this.setSubmittedSelectedItem(null);
        if (!previous.equalsIgnoreCase(submittedValue)) {
            this.queueEvent(new SelectedItemChangeEvent((UIComponent)this, previous, submittedValue));
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof SelectedItemChangeEvent && event.getComponent() == this) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (this.isBypassUpdates()) {
                event.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof SelectedItemChangeEvent && this.isBypassUpdates()) {
            FacesContext.getCurrentInstance().renderResponse();
        }
    }

    @Override
    public String getFamily() {
        return "org.richfaces.panels.TogglePanel";
    }

    public boolean getRendersChildren() {
        return true;
    }

    private boolean isSelectedItem(UIComponent kid) {
        String value = this.getSelectedItem();
        if (value == null) {
            value = this.getSubmittedSelectedItem();
        }
        return AbstractTogglePanel.getChildName(kid).equals(value);
    }

    public String getFirstItem() {
        AbstractTogglePanel.checkChildCount(this.getChildCount());
        return AbstractTogglePanel.getChildName((UIComponent)this.getChildren().get(0));
    }

    private static void checkChildCount(int childCount) {
        if (childCount < 1) {
            throw new IllegalStateException("TogglePanel must have at least one TogglePanelItem.");
        }
    }

    public AbstractTogglePanelItem getItem(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is required parameter.");
        }
        AbstractTogglePanel.checkChildCount(this.getChildCount());
        List children = this.getChildren();
        int index = AbstractTogglePanel.getChildIndex(name, children);
        if (index == -1) {
            return null;
        }
        return (AbstractTogglePanelItem)((Object)children.get(index));
    }

    public String getNext(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is required parameter.");
        }
        AbstractTogglePanel.checkChildCount(this.getChildCount());
        List children = this.getChildren();
        int nextItem = AbstractTogglePanel.getChildIndex(name, children) + 1;
        if (nextItem < children.size()) {
            return this.getFirstItem();
        }
        return AbstractTogglePanel.getChildName((UIComponent)children.get(nextItem));
    }

    private static int getChildIndex(String name, List<UIComponent> children) {
        for (int ind = 0; ind < children.size(); ++ind) {
            UIComponent child = children.get(ind);
            if (!name.equals(AbstractTogglePanel.getChildName(child))) continue;
            return ind;
        }
        return -1;
    }

    private static String getChildName(UIComponent item) {
        if (!(item instanceof AbstractTogglePanelItem)) {
            throw new IllegalStateException("TogglePanel can contain only TogglePanelItem as child.");
        }
        return ((AbstractTogglePanelItem)item).getName();
    }

    public String getSubmittedSelectedItem() {
        return this.submittedSelectedItem;
    }

    public void setSubmittedSelectedItem(String submittedSelectedItem) {
        this.submittedSelectedItem = submittedSelectedItem;
    }

    public String getSelectedItem() {
        return (String)this.getValue();
    }

    public void setSelectedItem(String value) {
        this.setValue(value);
    }

    public abstract Method getSwitchType();

    public abstract boolean isBypassUpdates();

    public abstract boolean isLimitToList();

    public abstract Object getData();

    public abstract String getStatus();

    public abstract Object getExecute();

    public abstract Object getRender();

    public abstract MethodExpression getSelectedItemChangeListener();

    public void addSelectedItemChangeListener(SelectedItemChangeListener listener) {
        this.addFacesListener(listener);
    }

    public SelectedItemChangeListener[] getSelectedItemChangeListeners() {
        return (SelectedItemChangeListener[])this.getFacesListeners(SelectedItemChangeListener.class);
    }

    public void removeSelectedItemChangeListener(SelectedItemChangeListener listener) {
        this.removeFacesListener(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropertyKeys {
        localValueSet,
        required,
        valid,
        immediate;

    }
}

