/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.plugins.client.httpclient;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.util.List;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.resteasy.ClientInvoker;
import org.resteasy.Marshaller;
import org.resteasy.MessageBodyParameterMarshaller;
import org.resteasy.plugins.client.httpclient.BodyRequestEntity;
import org.resteasy.plugins.client.httpclient.HttpOutputMessage;
import org.resteasy.specimpl.MultivaluedMapImpl;
import org.resteasy.specimpl.UriBuilderImpl;
import org.resteasy.spi.ClientResponse;
import org.resteasy.spi.ResteasyProviderFactory;
import org.resteasy.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpClientInvoker
extends ClientInvoker {
    private HttpClient client;

    public HttpClientInvoker(HttpClient client, Class<?> declaring, Method method, ResteasyProviderFactory providerFactory) {
        super(declaring, method, providerFactory);
        this.client = client;
    }

    public abstract HttpMethodBase createBaseMethod(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object[] args) {
        if (this.builder == null) {
            throw new RuntimeException("You have not set a base URI for the client proxy");
        }
        HttpOutputMessage output = new HttpOutputMessage(null);
        UriBuilderImpl uri = (UriBuilderImpl)this.builder.clone();
        int i = 0;
        BodyRequestEntity body = null;
        for (Marshaller param : this.params) {
            if (param instanceof MessageBodyParameterMarshaller) {
                MessageBodyParameterMarshaller bodyMarshaller = (MessageBodyParameterMarshaller)param;
                body = new BodyRequestEntity(args[i], this.method.getGenericParameterTypes()[i], this.method.getParameterAnnotations()[i], bodyMarshaller, output.getOutputHeaders());
            } else {
                param.marshall(args[i], uri, output);
            }
            ++i;
        }
        String url = null;
        HttpMethodBase baseMethod = null;
        try {
            url = uri.build().toURL().toString();
            baseMethod = this.createBaseMethod(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to build URL from uri", e);
        }
        for (String key : output.getOutputHeaders().keySet()) {
            List value = (List)output.getOutputHeaders().get((Object)key);
            for (Object obj : value) {
                baseMethod.addRequestHeader(key, obj.toString());
            }
        }
        if (this.accepts != null) {
            baseMethod.setRequestHeader("Accept", this.accepts.toString());
        }
        if (body != null) {
            ((EntityEnclosingMethod)baseMethod).setRequestEntity((RequestEntity)body);
        }
        int status = 0;
        try {
            status = this.client.executeMethod((HttpMethod)baseMethod);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to execute GET request: " + url, e);
        }
        try {
            Object var9_13;
            if (this.method.getReturnType().equals(Response.Status.class)) {
                Response.Status e = Response.Status.fromStatusCode((int)status);
                return e;
            }
            if (ClientResponse.class.isAssignableFrom(this.method.getReturnType())) {
                ParameterizedType zType = (ParameterizedType)this.method.getGenericReturnType();
                Type genericReturnType = zType.getActualTypeArguments()[0];
                Class<?> returnType = Types.getRawType(genericReturnType);
                ClientResponse clientResponse = this.extractClientResponse(baseMethod, status, genericReturnType, returnType);
                return clientResponse;
            }
            if (this.method.getReturnType() != null && !this.method.getReturnType().equals(Void.TYPE)) {
                var9_13 = this.extractClientResponse(baseMethod, status, this.method.getGenericReturnType(), this.method.getReturnType()).getEntity();
                return var9_13;
            }
            var9_13 = null;
            return var9_13;
        }
        finally {
            baseMethod.releaseConnection();
        }
    }

    protected ClientResponse extractClientResponse(HttpMethodBase baseMethod, int status, Type genericReturnType, Class returnType) {
        final MultivaluedMapImpl headers = new MultivaluedMapImpl();
        final int theStatus = status;
        for (Header header : baseMethod.getResponseHeaders()) {
            headers.add(header.getName(), header.getValue());
        }
        Header contentType = baseMethod.getResponseHeader("Content-Type");
        if (contentType == null) {
            return new ClientResponse(){

                public Object getEntity() {
                    return null;
                }

                public MultivaluedMap getHeaders() {
                    return headers;
                }

                public int getStatus() {
                    return theStatus;
                }
            };
        }
        String mediaType = baseMethod.getResponseHeader("Content-Type").getValue();
        if (mediaType == null) {
            ProduceMime produce = this.method.getAnnotation(ProduceMime.class);
            if (produce == null) {
                produce = this.declaring.getAnnotation(ProduceMime.class);
            }
            if (produce == null) {
                return new ClientResponse(){

                    public Object getEntity() {
                        throw new RuntimeException("Unable to determine content type of response for " + HttpClientInvoker.this.method.toString());
                    }

                    public MultivaluedMap getHeaders() {
                        return headers;
                    }

                    public int getStatus() {
                        return theStatus;
                    }
                };
            }
            mediaType = produce.value()[0];
        }
        MediaType media = MediaType.valueOf((String)mediaType);
        MessageBodyReader reader = this.providerFactory.createMessageBodyReader(returnType, genericReturnType, this.method.getAnnotations(), media);
        if (reader == null) {
            final String theMediaType = mediaType;
            return new ClientResponse(){

                public Object getEntity() {
                    throw new RuntimeException("Unable to find a MessageBodyReader of content-type " + theMediaType + " for response of " + HttpClientInvoker.this.method.toString());
                }

                public MultivaluedMap getHeaders() {
                    return headers;
                }

                public int getStatus() {
                    return theStatus;
                }
            };
        }
        try {
            final Object response = reader.readFrom(returnType, genericReturnType, this.method.getAnnotations(), media, headers, baseMethod.getResponseBodyAsStream());
            return new ClientResponse(){

                public Object getEntity() {
                    return response;
                }

                public MultivaluedMap getHeaders() {
                    return headers;
                }

                public int getStatus() {
                    return theStatus;
                }
            };
        }
        catch (IOException e) {
            return new ClientResponse(){

                public Object getEntity() {
                    throw new RuntimeException("Unable to unmarshall response for " + HttpClientInvoker.this.method.toString(), e);
                }

                public MultivaluedMap getHeaders() {
                    return headers;
                }

                public int getStatus() {
                    return theStatus;
                }
            };
        }
    }
}

