/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.resteasy.util.StringToPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringParameterInjector {
    protected Class type;
    protected Class baseType;
    protected Constructor constructor;
    protected Method valueOf;
    protected String defaultValue;
    protected String paramName;
    protected String paramType;
    protected boolean isList;
    protected AccessibleObject target;

    public StringParameterInjector() {
    }

    public StringParameterInjector(Class type, Type genericType, String paramName, String paramType, String defaultValue, AccessibleObject target) {
        this.initialize(type, genericType, paramName, paramType, defaultValue, target);
    }

    protected void initialize(Class type, Type genericType, String paramName, String paramType, String defaultValue, AccessibleObject target) {
        this.type = type;
        this.paramName = paramName;
        this.paramType = paramType;
        this.defaultValue = defaultValue;
        this.target = target;
        this.baseType = type;
        if (type.isArray()) {
            this.baseType = type.getComponentType();
        }
        if (List.class.isAssignableFrom(type)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType zType = (ParameterizedType)genericType;
                this.baseType = (Class)zType.getActualTypeArguments()[0];
            } else {
                this.baseType = String.class;
            }
            this.isList = true;
        }
        if (!this.baseType.isPrimitive()) {
            try {
                this.constructor = this.baseType.getConstructor(String.class);
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
            if (this.constructor == null) {
                try {
                    this.valueOf = this.baseType.getDeclaredMethod("valueOf", String.class);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Unable to find a constructor that takes a String param or a valueOf() method for " + this.getParamSignature() + " on " + target + " for basetype: " + this.baseType.getName());
                }
            }
        }
    }

    public String getParamSignature() {
        return this.paramType + "(\"" + this.paramName + "\")";
    }

    public Object extractValues(List<String> values) {
        if (values == null && (this.type.isArray() || this.isList) && this.defaultValue != null) {
            values = new ArrayList<String>(1);
            values.add(this.defaultValue);
        }
        if (this.type.isArray()) {
            if (values == null) {
                return null;
            }
            Object vals = Array.newInstance(this.type.getComponentType(), values.size());
            for (int i = 0; i < values.size(); ++i) {
                Array.set(vals, i, this.extractValue(values.get(i)));
            }
            return vals;
        }
        if (this.isList) {
            if (values == null) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (String str : values) {
                list.add(this.extractValue(str));
            }
            return list;
        }
        if (values == null) {
            return this.extractValue(null);
        }
        if (values.size() == 0) {
            return this.extractValue(null);
        }
        return this.extractValue(values.get(0));
    }

    public Object extractValue(String strVal) {
        if (strVal == null) {
            if (this.defaultValue == null) {
                if (!this.baseType.isPrimitive()) {
                    return null;
                }
            } else {
                strVal = this.defaultValue;
            }
        }
        if (this.baseType.isPrimitive()) {
            return StringToPrimitive.stringToPrimitiveBoxType(this.baseType, strVal);
        }
        if (this.constructor != null) {
            try {
                return this.constructor.newInstance(strVal);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to extract parameter from http request for " + this.getParamSignature() + " value is '" + strVal + "'" + " for " + this.target, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to extra parameter from http request: " + this.getParamSignature() + " value is '" + strVal + "'" + " for " + this.target, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Unable to extra parameter from http request: " + this.getParamSignature() + " value is '" + strVal + "'" + " for " + this.target, e.getTargetException());
            }
        }
        if (this.valueOf != null) {
            try {
                return this.valueOf.invoke(null, strVal);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to extra parameter from http request: " + this.getParamSignature() + " value is '" + strVal + "'" + " for " + this.target, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Unable to extra parameter from http request: " + this.getParamSignature() + " value is '" + strVal + "'" + " for " + this.target, e.getTargetException());
            }
        }
        return null;
    }
}

