/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import javax.ws.rs.CookieParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import org.resteasy.CookieParamMarshaller;
import org.resteasy.HeaderParamMarshaller;
import org.resteasy.Marshaller;
import org.resteasy.MatrixParamMarshaller;
import org.resteasy.MessageBodyParameterMarshaller;
import org.resteasy.PathParamMarshaller;
import org.resteasy.QueryParamMarshaller;
import org.resteasy.specimpl.UriBuilderImpl;
import org.resteasy.spi.ResteasyProviderFactory;
import org.resteasy.util.FindAnnotation;
import org.resteasy.util.MediaTypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientInvoker {
    protected ResteasyProviderFactory providerFactory;
    protected Method method;
    protected Marshaller[] params;
    protected UriBuilderImpl builder;
    protected Class declaring;
    protected MediaType accepts;

    public ClientInvoker(Class<?> declaring, Method method, ResteasyProviderFactory providerFactory) {
        this.declaring = declaring;
        this.method = method;
        this.providerFactory = providerFactory;
        this.params = new Marshaller[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> type = method.getParameterTypes()[i];
            Annotation[] annotations = method.getParameterAnnotations()[i];
            QueryParam query = FindAnnotation.findAnnotation(annotations, QueryParam.class);
            if (query != null) {
                this.params[i] = new QueryParamMarshaller(query.value());
                continue;
            }
            HeaderParam header = FindAnnotation.findAnnotation(annotations, HeaderParam.class);
            if (header != null) {
                this.params[i] = new HeaderParamMarshaller(header.value());
                continue;
            }
            CookieParam cookie = FindAnnotation.findAnnotation(annotations, CookieParam.class);
            if (cookie != null) {
                this.params[i] = new CookieParamMarshaller(cookie.value());
                continue;
            }
            PathParam uriParam = FindAnnotation.findAnnotation(annotations, PathParam.class);
            if (uriParam != null) {
                this.params[i] = new PathParamMarshaller(uriParam.value());
                continue;
            }
            MatrixParam matrix = FindAnnotation.findAnnotation(annotations, MatrixParam.class);
            if (matrix != null) {
                this.params[i] = new MatrixParamMarshaller(matrix.value());
                continue;
            }
            if (type.equals(Cookie.class)) {
                this.params[i] = new CookieParamMarshaller(null);
                continue;
            }
            MediaType mediaType = MediaTypeHelper.getConsumes(declaring, method);
            if (mediaType == null) {
                mediaType = this.determineMediaType();
            }
            this.params[i] = new MessageBodyParameterMarshaller(mediaType, type, method.getGenericParameterTypes()[i], method.getParameterAnnotations()[i], providerFactory);
        }
        this.accepts = MediaTypeHelper.getProduces(declaring, method);
    }

    public void setBaseUri(URI uri) {
        this.builder = new UriBuilderImpl();
        this.builder.uri(uri);
        this.builder.path(this.declaring);
        this.builder.path(this.method);
    }

    public MediaType determineMediaType() {
        throw new RuntimeException("You must define a @ConsumeMime type.  In the future we will");
    }

    public abstract Object invoke(Object[] var1);
}

