/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.util.Date;
import org.quartz.Calendar;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.impl.triggers.AbstractTrigger;

public class DateIntervalTrigger
extends AbstractTrigger {
    private static final long serialVersionUID = -2635982274232850343L;
    public static final int MISFIRE_INSTRUCTION_FIRE_ONCE_NOW = 1;
    public static final int MISFIRE_INSTRUCTION_DO_NOTHING = 2;
    private static final int YEAR_TO_GIVEUP_SCHEDULING_AT = 2299;
    private Date startTime = null;
    private Date endTime = null;
    private Date nextFireTime = null;
    private Date previousFireTime = null;
    private int repeatInterval = 0;
    private IntervalUnit repeatIntervalUnit = IntervalUnit.DAY;
    private int timesTriggered = 0;
    private boolean complete = false;

    public DateIntervalTrigger() {
    }

    public DateIntervalTrigger(String name, IntervalUnit intervalUnit, int repeatInterval) {
        this(name, null, intervalUnit, repeatInterval);
    }

    public DateIntervalTrigger(String name, String group, IntervalUnit intervalUnit, int repeatInterval) {
        this(name, group, new Date(), null, intervalUnit, repeatInterval);
    }

    public DateIntervalTrigger(String name, Date startTime, Date endTime, IntervalUnit intervalUnit, int repeatInterval) {
        this(name, null, startTime, endTime, intervalUnit, repeatInterval);
    }

    public DateIntervalTrigger(String name, String group, Date startTime, Date endTime, IntervalUnit intervalUnit, int repeatInterval) {
        super(name, group);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setRepeatIntervalUnit(intervalUnit);
        this.setRepeatInterval(repeatInterval);
    }

    public DateIntervalTrigger(String name, String group, String jobName, String jobGroup, Date startTime, Date endTime, IntervalUnit intervalUnit, int repeatInterval) {
        super(name, group, jobName, jobGroup);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setRepeatIntervalUnit(intervalUnit);
        this.setRepeatInterval(repeatInterval);
    }

    public Date getStartTime() {
        if (this.startTime == null) {
            this.startTime = new Date();
        }
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && startTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = endTime;
    }

    public IntervalUnit getRepeatIntervalUnit() {
        return this.repeatIntervalUnit;
    }

    public void setRepeatIntervalUnit(IntervalUnit intervalUnit) {
        this.repeatIntervalUnit = intervalUnit;
    }

    public int getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(int repeatInterval) {
        if (repeatInterval < 0) {
            throw new IllegalArgumentException("Repeat interval must be >= 1");
        }
        this.repeatInterval = repeatInterval;
    }

    public int getTimesTriggered() {
        return this.timesTriggered;
    }

    public void setTimesTriggered(int timesTriggered) {
        this.timesTriggered = timesTriggered;
    }

    protected boolean validateMisfireInstruction(int misfireInstruction) {
        if (misfireInstruction < 0) {
            return false;
        }
        return misfireInstruction <= 2;
    }

    public void updateAfterMisfire(Calendar cal) {
        int instr = this.getMisfireInstruction();
        if (instr == 0) {
            instr = 1;
        }
        if (instr == 2) {
            Date newFireTime = this.getFireTimeAfter(new Date());
            while (newFireTime != null && cal != null && !cal.isTimeIncluded(newFireTime.getTime())) {
                newFireTime = this.getFireTimeAfter(newFireTime);
            }
            this.setNextFireTime(newFireTime);
        } else if (instr == 1) {
            this.setNextFireTime(new Date());
        }
    }

    public void triggered(Calendar calendar) {
        ++this.timesTriggered;
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar c = java.util.Calendar.getInstance();
            c.setTime(this.nextFireTime);
            if (c.get(1) <= 2299) continue;
            this.nextFireTime = null;
        }
    }

    public void updateWithNewCalendar(Calendar calendar, long misfireThreshold) {
        this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
        if (this.nextFireTime == null || calendar == null) {
            return;
        }
        Date now = new Date();
        while (this.nextFireTime != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            long diff;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar c = java.util.Calendar.getInstance();
            c.setTime(this.nextFireTime);
            if (c.get(1) > 2299) {
                this.nextFireTime = null;
            }
            if (this.nextFireTime == null || !this.nextFireTime.before(now) || (diff = now.getTime() - this.nextFireTime.getTime()) < misfireThreshold) continue;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.nextFireTime = this.getStartTime();
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar c = java.util.Calendar.getInstance();
            c.setTime(this.nextFireTime);
            if (c.get(1) <= 2299) continue;
            return null;
        }
        return this.nextFireTime;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public void setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    public Date getFireTimeAfter(Date afterTime) {
        return this.getFireTimeAfter(afterTime, false);
    }

    protected Date getFireTimeAfter(Date afterTime, boolean ignoreEndTime) {
        long endMillis;
        if (this.complete) {
            return null;
        }
        afterTime = afterTime == null ? new Date(System.currentTimeMillis() + 1000L) : new Date(afterTime.getTime() + 1000L);
        long startMillis = this.getStartTime().getTime();
        long afterMillis = afterTime.getTime();
        long l = endMillis = this.getEndTime() == null ? Long.MAX_VALUE : this.getEndTime().getTime();
        if (!ignoreEndTime && endMillis <= afterMillis) {
            return null;
        }
        if (afterMillis < startMillis) {
            return new Date(startMillis);
        }
        long secondsAfterStart = (afterMillis - startMillis) / 1000L;
        Date time = null;
        long repeatLong = this.getRepeatInterval();
        java.util.Calendar aTime = java.util.Calendar.getInstance();
        aTime.setTime(afterTime);
        java.util.Calendar sTime = java.util.Calendar.getInstance();
        sTime.setTime(this.getStartTime());
        sTime.setLenient(true);
        if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.SECOND)) {
            long jumpCount = secondsAfterStart / repeatLong;
            if (secondsAfterStart % repeatLong != 0L) {
                ++jumpCount;
            }
            sTime.add(13, this.getRepeatInterval() * (int)jumpCount);
            time = sTime.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.MINUTE)) {
            long jumpCount = secondsAfterStart / (repeatLong * 60L);
            if (secondsAfterStart % (repeatLong * 60L) != 0L) {
                ++jumpCount;
            }
            sTime.add(12, this.getRepeatInterval() * (int)jumpCount);
            time = sTime.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.HOUR)) {
            long jumpCount = secondsAfterStart / (repeatLong * 60L * 60L);
            if (secondsAfterStart % (repeatLong * 60L * 60L) != 0L) {
                ++jumpCount;
            }
            sTime.add(11, this.getRepeatInterval() * (int)jumpCount);
            time = sTime.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.DAY)) {
            sTime.setLenient(true);
            long jumpCount = secondsAfterStart / (repeatLong * 24L * 60L * 60L);
            if (jumpCount > 20L) {
                jumpCount = jumpCount < 50L ? (long)((double)jumpCount * 0.8) : (jumpCount < 500L ? (long)((double)jumpCount * 0.9) : (long)((double)jumpCount * 0.95));
                sTime.add(6, (int)((long)this.getRepeatInterval() * jumpCount));
            }
            while (sTime.getTime().before(afterTime) && sTime.get(1) < 2299) {
                sTime.add(6, this.getRepeatInterval());
            }
            time = sTime.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.WEEK)) {
            sTime.setLenient(true);
            long jumpCount = secondsAfterStart / (repeatLong * 7L * 24L * 60L * 60L);
            if (jumpCount > 20L) {
                jumpCount = jumpCount < 50L ? (long)((double)jumpCount * 0.8) : (jumpCount < 500L ? (long)((double)jumpCount * 0.9) : (long)((double)jumpCount * 0.95));
                sTime.add(3, (int)((long)this.getRepeatInterval() * jumpCount));
            }
            while (sTime.getTime().before(afterTime) && sTime.get(1) < 2299) {
                sTime.add(3, this.getRepeatInterval());
            }
            time = sTime.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.MONTH)) {
            sTime.setLenient(true);
            while (sTime.getTime().before(afterTime) && sTime.get(1) < 2299) {
                sTime.add(2, this.getRepeatInterval());
            }
            time = sTime.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.YEAR)) {
            while (sTime.getTime().before(afterTime) && sTime.get(1) < 2299) {
                sTime.add(1, this.getRepeatInterval());
            }
            time = sTime.getTime();
        }
        if (!ignoreEndTime && endMillis <= time.getTime()) {
            return null;
        }
        return time;
    }

    public Date getFinalFireTime() {
        if (this.complete || this.getEndTime() == null) {
            return null;
        }
        Date fTime = new Date(this.getEndTime().getTime() - 1000L);
        if ((fTime = this.getFireTimeAfter(fTime, true)).equals(this.getEndTime())) {
            return fTime;
        }
        java.util.Calendar lTime = java.util.Calendar.getInstance();
        lTime.setTime(fTime);
        lTime.setLenient(true);
        if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.SECOND)) {
            lTime.add(13, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.MINUTE)) {
            lTime.add(12, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.HOUR)) {
            lTime.add(11, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.DAY)) {
            lTime.add(6, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.WEEK)) {
            lTime.add(3, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.MONTH)) {
            lTime.add(2, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.YEAR)) {
            lTime.add(1, -1 * this.getRepeatInterval());
        }
        return lTime.getTime();
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    public void validate() throws SchedulerException {
        super.validate();
        if (this.repeatInterval < 1) {
            throw new SchedulerException("Repeat Interval cannot be zero.");
        }
    }

    public ScheduleBuilder getScheduleBuilder() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IntervalUnit {
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }
}

