/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.function;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.function.Function;
import org.planx.xpath.function.FunctionException;
import org.planx.xpath.object.XNodeSet;
import org.planx.xpath.object.XNumber;
import org.planx.xpath.object.XObject;
import org.planx.xpath.object.XSimple;
import org.planx.xpath.object.XString;

public class NumberFunction
implements Function {
    @Override
    public XObject evaluate(XObject[] args, Context ctxt, Environment env, Navigator nav) throws FunctionException {
        if (args.length == 0) {
            return this.evaluate(ctxt.getNode(), nav);
        }
        if (args.length == 1) {
            return this.evaluate(args[0], nav);
        }
        throw new FunctionException("Illegal number of arguments");
    }

    public XObject evaluate(Object arg, Navigator navigator) throws FunctionException {
        try {
            if (arg instanceof XNumber) {
                return (XNumber)arg;
            }
            if (arg instanceof XNodeSet) {
                XNodeSet set = (XNodeSet)arg;
                if (set.size() == 0) {
                    return XNumber.NaN;
                }
                return this.convertNode(set.get(0), navigator);
            }
            if (arg instanceof XSimple) {
                return new XNumber(((XSimple)arg).doubleValue());
            }
            return this.convertNode(arg, navigator);
        }
        catch (XPathException e) {
            throw new FunctionException(e);
        }
    }

    private XNumber convertNode(Object node, Navigator navigator) throws XPathException {
        XString value = new XString(navigator.getStringValue(node));
        return new XNumber(value.doubleValue());
    }
}

