/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.operator;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.object.XObject;

public abstract class Operator
extends Expression {
    protected final Expression e1;
    protected final Expression e2;

    public Operator(Expression e1, Expression e2) {
        this.e1 = e1;
        this.e2 = e2;
    }

    @Override
    public XObject evaluate(Context ctxt, Environment env, Navigator nav) throws XPathException {
        XObject value1 = this.e1.evaluate(ctxt, env, nav);
        XObject value2 = this.e2.evaluate(ctxt, env, nav);
        return this.evaluate(value1, value2, nav);
    }

    protected abstract XObject evaluate(XObject var1, XObject var2, Navigator var3) throws XPathException;

    protected abstract String operatorName();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.e1 instanceof Operator) {
            sb.append("(");
            sb.append(this.e1.toString());
            sb.append(")");
        } else {
            sb.append(this.e1.toString());
        }
        sb.append(this.operatorName());
        if (this.e2 instanceof Operator) {
            sb.append("(");
            sb.append(this.e2.toString());
            sb.append(")");
        } else {
            sb.append(this.e2.toString());
        }
        return sb.toString();
    }
}

