/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.axis.Axis;
import org.planx.xpath.expr.axis.AxisIterator;

public class DescendantAxis
extends Axis {
    private final boolean includeSelf;

    public DescendantAxis() {
        this(false);
    }

    public DescendantAxis(boolean includeSelf) {
        this.includeSelf = includeSelf;
    }

    @Override
    public AxisIterator iterator(Object contextNode, Navigator navigator) throws XPathException {
        return new DescendantAxisIterator(contextNode, navigator, this.includeSelf);
    }

    @Override
    public int getPrincipalNodeType() {
        return 2;
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    public String toString() {
        if (this.includeSelf) {
            return "descendant-or-self";
        }
        return "descendant";
    }

    class DescendantAxisIterator
    implements AxisIterator {
        private Object contextNode;
        private Navigator navigator;
        private int count;
        private int current;
        private AxisIterator currentIterator = null;

        DescendantAxisIterator(Object contextNode, Navigator navigator, boolean includeSelf) throws XPathException {
            this.contextNode = contextNode;
            this.navigator = navigator;
            this.count = navigator.childCount(contextNode);
            this.current = includeSelf ? -1 : 0;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.count || this.currentIterator != null && this.currentIterator.hasNext();
        }

        @Override
        public Object next() throws XPathException {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                if (this.current >= this.count) {
                    throw new XPathException("No more elements in iterator");
                }
                if (this.current == -1) {
                    ++this.current;
                    return this.contextNode;
                }
                Object child = this.navigator.getChild(this.contextNode, this.current++);
                this.currentIterator = new DescendantAxisIterator(child, this.navigator, true);
            }
            return this.currentIterator.next();
        }
    }
}

