/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.axis.Axis;
import org.planx.xpath.expr.axis.AxisIterator;

public class ChildAxis
extends Axis {
    @Override
    public AxisIterator iterator(Object contextNode, Navigator navigator) throws XPathException {
        return new ChildAxisIterator(contextNode, navigator);
    }

    @Override
    public int getPrincipalNodeType() {
        return 2;
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    public String toString() {
        return "child";
    }

    class ChildAxisIterator
    implements AxisIterator {
        private Object contextNode;
        private Navigator navigator;
        private int count;
        private int current = 0;

        ChildAxisIterator(Object contextNode, Navigator navigator) throws XPathException {
            this.contextNode = contextNode;
            this.navigator = navigator;
            this.count = navigator.childCount(contextNode);
        }

        @Override
        public boolean hasNext() {
            return this.current < this.count;
        }

        @Override
        public Object next() throws XPathException {
            if (this.current >= this.count) {
                throw new XPathException("No more elements in iterator");
            }
            return this.navigator.getChild(this.contextNode, this.current++);
        }
    }
}

