/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.stores;

import java.io.IOException;
import java.util.LinkedList;
import org.planx.util.ThreadPool;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.XMLStore;
import org.planx.xmlstore.stores.AbstractXMLStore;

public class ReplicatorXMLStore
extends AbstractXMLStore {
    private LinkedList xmlstores;
    private ThreadPool _pool;
    private Reference _saved_vref;
    private Node _loaded_node = null;

    public ReplicatorXMLStore(LinkedList xmlstores) {
        this.xmlstores = xmlstores;
        this._pool = new ThreadPool();
    }

    @Override
    public void close() {
    }

    @Override
    protected void checkClosed() {
    }

    @Override
    public synchronized Reference save(Node n) {
        this.checkClosed();
        System.out.println("Saving value");
        this._saved_vref = null;
        for (XMLStore xmlstore : this.xmlstores) {
            this._pool.addWork(new SaveThread(this, xmlstore, n));
        }
        try {
            while (this._saved_vref == null) {
                this.wait();
            }
            return this._saved_vref;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    protected synchronized void setSaveResult(Reference vref) {
        this._saved_vref = vref;
        this.notify();
    }

    @Override
    public synchronized Node load(Reference vref) {
        this.checkClosed();
        System.out.println("Loading value");
        this._loaded_node = null;
        for (XMLStore xmlstore : this.xmlstores) {
            this._pool.addWork(new LoadThread(this, xmlstore, vref));
        }
        try {
            System.out.println("Waiting ...");
            while (this._loaded_node == null) {
                this.wait();
            }
            System.out.println("Returning ...");
            return this._loaded_node;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    protected synchronized void setLoadResult(Node node) {
        this._loaded_node = node;
        this.notify();
    }

    private class LoadThread
    implements Runnable {
        ReplicatorXMLStore owner;
        XMLStore xmlstore;
        Reference vref;

        public LoadThread(ReplicatorXMLStore owner, XMLStore xmlstore, Reference vref) {
            this.owner = owner;
            this.xmlstore = xmlstore;
            this.vref = vref;
        }

        @Override
        public void run() {
            Node node;
            try {
                node = this.xmlstore.load(this.vref);
            }
            catch (IOException e) {
                node = null;
            }
            catch (UnknownReferenceException e) {
                node = null;
            }
            System.out.println("Okay, finally loaded" + node == null ? ", but it is null" : "");
            this.owner.setLoadResult(node);
        }
    }

    private class SaveThread
    implements Runnable {
        ReplicatorXMLStore owner;
        XMLStore xmlstore;
        Node node;

        public SaveThread(ReplicatorXMLStore owner, XMLStore xmlstore, Node n) {
            this.owner = owner;
            this.xmlstore = xmlstore;
            this.node = n;
        }

        @Override
        public void run() {
            Reference vref;
            try {
                vref = this.xmlstore.save(this.node);
            }
            catch (IOException e) {
                vref = null;
            }
            System.out.println("Okay, finally saved");
            this.owner.setSaveResult(vref);
        }
    }
}

